// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file MinMover.cc
/// @brief
/// @author ashworth

// Unit headers
#include <protocols/moves/symmetry/SymmetricRMSMover.hh>

// Package headers
#include <core/conformation/symmetry/SymmetricConformation.hh>
#include <core/conformation/symmetry/util.hh>

#include <core/util/datacache/BasicDataCache.hh>
#include <core/util/datacache/DiagnosticData.hh>
#include <core/pose/datacache/CacheableDataType.hh>

#include <protocols/ScoreMap.hh>
#include <core/scoring/rms_util.hh>
// ObjexxFCL Headers

// C++ Headers

// Utility Headers
#include <core/util/Tracer.hh>

namespace protocols {
namespace moves {
namespace symmetry {

static core::util::Tracer TR("protocols.moves.symmetry.SymmetricRMSMover");

SymmetricRMSMover::SymmetricRMSMover()
	: Mover("SymmetricRMSMover") {}

SymmetricRMSMover::~SymmetricRMSMover(){}

void
SymmetricRMSMover::apply( core::pose::Pose & pose )
{
			using namespace core::util::datacache;
			using core::pose::datacache::CacheableDataType::SCORE_MAP;

			std::map < std::string, core::Real > score_map;
      if( !(pose.data().has( SCORE_MAP ) ) ) {
        score_map[ "NO_OUTPUT_TAG_CACHED_SORRY" ] = 0.0;
      } else {
				score_map = ( static_cast< DiagnosticData const &>( pose.data().get( SCORE_MAP ))).data() ;
			}

			assert( core::conformation::symmetry::is_symmetric( pose ) );
		  SymmetricConformation & SymmConf (
		    dynamic_cast<SymmetricConformation &> ( pose.conformation()) );
		  SymmetryInfo const & symm_info( SymmConf.Symmetry_Info() );

			FArray1D_bool superpos ( pose.total_residue(), false );
		  for (Size res=1; res <= symm_info.num_total_residues_without_pseudo(); ++res )
	    {
        superpos(res) = true;
	    }
			if ( get_native_pose() ) {
				core::Real const rms( core::scoring::rmsd_with_super_subset( *get_native_pose(), pose, superpos, core::scoring::is_protein_CA ) );
				score_map[ "rms" ] = rms;
				pose.data().set(SCORE_MAP, new core::util::datacache::DiagnosticData( score_map ));
			}

}

} // symmetry
} // moves
} // protocols
