// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file MultiStatePacker.hh
/// @brief
/// @author ashworth

#ifndef INCLUDED_protocols_multistate_design_MultiStatePacker_HH
#define INCLUDED_protocols_multistate_design_MultiStatePacker_HH

#include <protocols/multistate_design/MultiStatePacker.fwd.hh>
#include <protocols/multistate_design/MultiStateFitnessFunction.hh>
#include <protocols/multistate_design/SingleState.fwd.hh>
#include <protocols/multistate_design/PackingState.fwd.hh>

#include <core/chemical/AA.hh>

#include <core/types.hh>
#include <utility/vector1.fwd.hh>

#include <vector>
#include <iosfwd>

namespace protocols {
namespace multistate_design {

// the element to be stored by genetic_algorithm::Entity<T> for multistate optimization of residue sequence
class PosType {

public:
	PosType();
	virtual ~PosType();
	PosType( core::Size index, core::chemical::AA type );
	PosType( std::string const & word );

	core::Size index() const;
	core::chemical::AA type() const;

	bool operator < ( PosType const & other ) const;
	bool operator == ( PosType const & other ) const;

private:
	core::Size index_;
	core::chemical::AA type_;
};

std::ostream & operator << ( std::ostream & os, PosType const & pt );

std::size_t hash_value( PosType const & pt );

////////////////////////////////////////////////////////////////////////////////////////////////////
class MultiStatePacker : public MultiStateFitnessFunction< PosType > {

public:
	MultiStatePacker()
		: MultiStateFitnessFunction< PosType >(),
			num_packs_(1)
	{}

	virtual ~MultiStatePacker(){}

	MultiStatePacker( core::Size num_packs )
		: MultiStateFitnessFunction< PosType >(),
			num_packs_(num_packs)
	{}

	virtual void single_state_design( bool restrict_to_canonical = true );
	virtual core::Real evaluate( protocols::genetic_algorithm::Entity<PosType> & entity, core::Size single_state_num );

	virtual void set_num_packs( core::Size num ) { num_packs_ = num; }

private:
	core::Size num_packs_;
};

void
limit_rotamer_set(
  std::vector< int > & rot_to_pack,
  PackingState const & state,
  PosTypes const & seq
);

void
restrict_to_canonical_aas(
	PackingState const & state,
	std::vector< int > & rot_to_pack
);

} // namespace multistate_design
} // namespace protocols

#endif
