// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief initialization protocols for relax
/// @detailed
///	  Contains currently: Relax Baseclass, ClassicRelax Stage 1,2,3, ClassicRelax
///
///
/// @author Mike Tyka


#ifndef INCLUDED_protocols_relax_FastMultiRelax_HH
#define INCLUDED_protocols_relax_FastMultiRelax_HH

#include <protocols/relax/RelaxProtocolBase.hh>
// #include <protocols/moves/Mover.hh>
// #include <protocols/moves/MinMover.fwd.hh>
// #include <protocols/moves/MoverContainer.fwd.hh>
// #include <protocols/moves/TrialMover.fwd.hh>
// #include <protocols/moves/RotamerTrialsMover.fwd.hh>
// #include <protocols/moves/PackRotamersMover.fwd.hh>
// #include <protocols/checkpoint/CheckPointer.hh>
// #include <core/scoring/EnergyMap.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
// #include <core/scoring/ScoreType.hh>
// #include <core/scoring/ScoreFunction.fwd.hh>
// #include <core/pack/task/PackerTask.fwd.hh>
// #include <core/pose/Pose.fwd.hh>
// #include <core/kinematics/MoveMap.hh>

//// C++ headers
#include <cstdlib>
#include <string>


namespace protocols {
namespace relax {



class FastMultiRelax: public RelaxProtocolBase {
public:
	typedef RelaxProtocolBase parent;

public:
	FastMultiRelax( core::scoring::ScoreFunctionOP scorefxn_in );
	FastMultiRelax( FastMultiRelax const & other );

	virtual ~FastMultiRelax();
	virtual protocols::moves::MoverOP clone() const;
	virtual void apply( core::pose::Pose & pose );
private:
	core::scoring::ScoreFunctionOP scorefxn_;
};


}
} // protocols

#endif
