// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief initialization protocols for relax
/// @detailed
///	  Contains currently: Relax Baseclass, ClassicRelax Stage 1,2,3, ClassicRelax
///
///
/// @author Mike Tyka


#ifndef INCLUDED_protocols_relax_RelaxProtocolBase_HH
#define INCLUDED_protocols_relax_RelaxProtocolBase_HH

#include <protocols/relax/RelaxProtocolBase.fwd.hh>

#include <core/pose/Pose.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <protocols/moves/Mover.hh>
#include <core/scoring/ScoreFunction.hh>

//// C++ headers
#include <cstdlib>
#include <string>


namespace protocols {
namespace relax {

class RelaxProtocolBase : public moves::Mover {
public:
	typedef moves::Mover parent;

public:

	RelaxProtocolBase();
	RelaxProtocolBase( core::scoring::ScoreFunctionOP );
	RelaxProtocolBase( std::string const & movername, core::scoring::ScoreFunctionOP = NULL );
	RelaxProtocolBase( RelaxProtocolBase const & );
	~RelaxProtocolBase();
	RelaxProtocolBase const & operator = ( RelaxProtocolBase const & rhs );


	void initialize_movemap( core::pose::Pose const & pose, core::kinematics::MoveMap & movemap );
	void output_debug_structure( core::pose::Pose & pose, std::string prefix );

	void minimize_bond_lengths( bool setting );
	void minimize_bond_angles( bool setting );
	void minimize_mainchain_bond_lengths( bool setting );
	void minimize_mainchain_bond_angles( bool setting );


	bool minimize_bond_lengths() const;
	bool minimize_bond_angles() const;
	bool minimize_mainchain_bond_lengths() const;
	bool minimize_mainchain_bond_angles() const;

	static void register_options();

	core::kinematics::MoveMapOP get_movemap() {
		return movemap_;
	}

	void set_movemap( core::kinematics::MoveMapOP movemap );
	void set_default_movemap();

	void set_scorefxn( core::scoring::ScoreFunctionOP score );

	core::scoring::ScoreFunctionCOP get_scorefxn() const;

protected:
	core::scoring::ScoreFunctionOP scorefxn();

private:

	bool minimize_bond_lengths_;
	bool minimize_bond_angles_;
	bool minimize_mainchain_bond_lengths_;
	bool minimize_mainchain_bond_angles_;

	core::kinematics::MoveMapOP movemap_;

	core::scoring::ScoreFunctionOP scorefxn_;

};

}
} // protocols

#endif
