// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief initialization protocols for relax
/// @detailed
///	  Contains currently: Relax Baseclass, ClassicRelax Stage 1,2,3, ClassicRelax
///
///
/// @author Mike Tyka


#ifndef INCLUDED_protocols_relax_SimpleMultiRelax_HH
#define INCLUDED_protocols_relax_SimpleMultiRelax_HH

#include <protocols/relax/RelaxProtocolBase.hh>

// #include <protocols/moves/Mover.hh>
// #include <protocols/moves/MinMover.fwd.hh>
// #include <protocols/moves/MoverContainer.fwd.hh>
// #include <protocols/moves/TrialMover.fwd.hh>
// #include <protocols/moves/RotamerTrialsMover.fwd.hh>
// #include <protocols/moves/PackRotamersMover.fwd.hh>
#include <protocols/checkpoint/CheckPointer.hh>
// #include <core/scoring/EnergyMap.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
// #include <core/scoring/ScoreType.hh>
// #include <core/scoring/ScoreFunction.fwd.hh>
// #include <core/pack/task/PackerTask.fwd.hh>
// #include <core/pose/Pose.fwd.hh>
// #include <core/kinematics/MoveMap.hh>

//// C++ headers
#include <cstdlib>
#include <string>


namespace protocols {
namespace relax {

class SimpleMultiRelax: public RelaxProtocolBase {
public:
	typedef RelaxProtocolBase parent;

public:
	SimpleMultiRelax(
		core::scoring::ScoreFunctionOP scorefxn_in
	);
	SimpleMultiRelax( SimpleMultiRelax const & );
	virtual ~SimpleMultiRelax();

	static void register_options();
	void set_to_default();

	virtual protocols::moves::MoverOP clone() const;
	virtual void apply( core::pose::Pose & pose );

	//adds the dummy score-values to the pose with tags that are also added in apply ( e.g. to keep the columns in silent files the same )
	static void setPoseExtraScores( core::pose::Pose &pose );

private:
	core::scoring::ScoreFunctionOP scorefxn_;
	protocols::checkpoint::CheckPointer checkpoints_;

	int repeats_;
	int phase1_cycles_;
	core::Real start_weight_low_;
	core::Real start_weight_hi_;
};

} // relax
} // protocols

#endif
