// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief initialization protocols for relax
/// @detailed
///	  Contains currently: Relax Baseclass, ClassicRelax Stage 1,2,3, ClassicRelax
///
///
/// @author Mike Tyka


#ifndef INCLUDED_protocols_relax_util_HH
#define INCLUDED_protocols_relax_util_HH
#include <core/scoring/ScoreFunction.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <protocols/relax/RelaxProtocolBase.hh>
#include <protocols/relax/ClassicRelax.hh>
#include <protocols/relax/SimpleMultiRelax.hh>
#include <protocols/relax/SequenceRelax.hh>
//// C++ headers
#include <cstdlib>
#include <string>


namespace protocols {
namespace relax {

int Relax_main( bool boinc_mode );

void relax_pose( core::pose::Pose& pose, core::scoring::ScoreFunctionOP scorefxn, std::string const& tag );

RelaxProtocolBaseOP generate_relax_from_cmd( bool NULL_if_no_cmd = false );

}
} // protocols

#endif
