// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file loopRNA_minimizer.hh
/// @brief
/// @detailed
///
/// @author James Thompson
/// @author Srivatsan Raman


#ifndef INCLUDED_protocols_rna_RNA_Minimizer_HH
#define INCLUDED_protocols_rna_RNA_Minimizer_HH

#include <core/types.hh>
#include <protocols/moves/Mover.hh>
#include <core/pose/Pose.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <protocols/rna/RNA_FragmentsClasses.fwd.hh>

//Oooh.
#include <ObjexxFCL/FArray1D.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <vector>

namespace protocols {
namespace rna {

/// @brief The RNA de novo structure modeling protocol
class RNA_Minimizer: public protocols::moves::Mover {
public:
	/// @brief Construct the protocol object given
	/// the RNA fragment library to use.
	RNA_Minimizer();

	/// @brief Clone this object
	virtual protocols::moves::MoverOP clone() const {
		return new RNA_Minimizer(*this);
	}

	/// @brief Apply the loop-rebuild protocol to the input pose
	void apply( core::pose::Pose & pose );

	// Undefinded, comented out to make python bindings complile
	//void apply( core::pose::Pose & pose, ObjexxFCL::FArray1D <bool> const & allow_insert );

	void deriv_check( bool const setting ){ deriv_check_ = setting; };

	void use_coordinate_constraints( bool const setting ){ use_coordinate_constraints_ = setting; };

	void skip_o2star_trials( bool const setting ){ skip_o2star_trials_ = setting; };

	void vary_bond_geometry( bool const setting ){ vary_bond_geometry_ = setting; };

	void
	set_allow_insert( FArray1D <bool> const & allow_insert  ){ allow_insert_ = allow_insert; }

private:

	//This function is sufficiently useful that it might
	// be worth putting it in a util.hh somewhere else.
	void
	add_coordinate_constraints( core::pose::Pose & pose ) const;

	// Make this a Mover?
	void
	o2star_trials( core::pose::Pose & pose, core::scoring::ScoreFunctionOP const & scorefxn,
								 bool const do_pack_instead_of_rotamer_trials = false ) const;

	void
	setup_movemap( core::kinematics::MoveMap & mm, core::pose::Pose & pose );

	void
	vary_bond_geometry(
										 core::kinematics::MoveMap & mm,
										 core::pose::Pose & pose,
										 core::pose::Pose const & pose_reference );

	void
	create_pose_reference(
												core::pose::Pose const & pose,
												core::pose::Pose & pose_reference );


	bool deriv_check_;
	bool use_coordinate_constraints_;
	bool skip_o2star_trials_;
	bool vary_bond_geometry_;

	FArray1D_bool allow_insert_;

}; // class RNA_Minimizer



} //rna
} // protocols

#endif
