// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file loopRNA_relaxer.hh
/// @brief
/// @detailed
///
/// @author James Thompson
/// @author Srivatsan Raman


#ifndef INCLUDED_protocols_rna_RNA_Relaxer_HH
#define INCLUDED_protocols_rna_RNA_Relaxer_HH

#include <core/types.hh>
#include <protocols/moves/Mover.hh>
#include <core/pose/Pose.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <protocols/rna/RNA_FragmentMover.fwd.hh>
#include <protocols/rna/RNA_Minimizer.fwd.hh>

//Oooh.
#include <ObjexxFCL/FArray1D.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <vector>

namespace protocols {
namespace rna {


typedef utility::pointer::owning_ptr< RNA_FragmentMover > RNA_FragmentMoverOP;
typedef utility::pointer::owning_ptr< RNA_Minimizer > RNA_MinimizerOP;

/// @brief The RNA de novo structure modeling protocol
class RNA_Relaxer: public protocols::moves::Mover {
public:
	/// @brief Construct the protocol object given
	/// the RNA fragment library to use.
	RNA_Relaxer( RNA_FragmentMoverOP & rna_fragment_mover, RNA_MinimizerOP & rna_minimizer );

	/// @brief Clone this object
		//	virtual RNA_Relaxer* clone() const	{
		//		return new RNA_Relaxer(*this);
		//	}

	/// @brief Apply the loop-rebuild protocol to the input pose
	void apply( core::pose::Pose & pose );

	void
  simple_rmsd_cutoff_relax( bool const setting ){ simple_rmsd_cutoff_relax_ = setting; }

private:

	void
	make_fragment_moves( core::pose::Pose & pose );

	void
	find_fragment_by_simple_rmsd_cutoff( core::pose::Pose & pose );

	void
	lores_monte_carlo( core::pose::Pose & pose );

	//data
	RNA_FragmentMoverOP rna_fragment_mover_;
	RNA_MinimizerOP rna_minimizer_;

	Size const relax_cycles_;
	Size const max_frag_size_;
	Size const num_find_fragment_tries_;
	core::Real const rmsd_min_cutoff_;
	core::Real const rmsd_max_cutoff_;

	bool simple_rmsd_cutoff_relax_;

}; // class RNA_Relaxer



} //rna
} // protocols

#endif
