// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file   protocols/symmetric_docking/SymDockProtocol.hh
///
/// @brief
/// @author Ingemar Andre


#ifndef INCLUDED_protocols_symmetric_docking_SymDockProtocol_HH
#define INCLUDED_protocols_symmetric_docking_SymDockProtocol_HH

#include <protocols/symmetric_docking/SymDockProtocol.fwd.hh>
#include <protocols/symmetric_docking/SymDockBaseProtocol.hh>

#include <core/types.hh>

#include <core/options/option.hh>
#include <core/options/keys/OptionKeys.hh>

#include <protocols/moves/Mover.hh>
#include <protocols/moves/OutputMovers.hh>

#include <protocols/symmetric_docking/SymDockingLowRes.hh>
#include <protocols/symmetric_docking/SymDockingHiRes.hh>

namespace protocols {
namespace symmetric_docking {

class SymDockProtocol : public protocols::symmetric_docking::SymDockBaseProtocol
{
public:

  SymDockProtocol();
  virtual ~SymDockProtocol();

	/// @brief setup that is called from constructor
	void set_default();

	/// @brief setter
	void view( bool view_in ) { view_=view_in; }

	bool docking_lowres_filter( core::pose::Pose & pose );
	bool docking_highres_filter( core::pose::Pose & pose );

	void calc_interaction_energy( core::pose::Pose & pose );

	core::Real
	calc_symmetric_rms( core::pose::Pose & pose );

  virtual void apply( core::pose::Pose & pose );

private:

 void
  classic_mcm_protocol(
    core::pose::Pose & pose,
    core::scoring::symmetry::SymmetricScoreFunctionOP scorefxn,
    protocols::moves::MonteCarloOP monteCarlo,
    core::Size num_cycles,
    core::Size repack_every_Nth
  ) const;

  protocols::moves::MoverOP
  make_dockmcm_mover(
    core::pose::Pose const & pose,
    protocols::moves::MoverOP repack_mover,
    protocols::moves::MoverOP rigbod_mover,
    core::kinematics::MoveMapOP movemap, //< would be COP but MinMover wants OP
    core::scoring::symmetry::SymmetricScoreFunctionOP scorefxn,
    protocols::moves::MonteCarloOP monteCarlo
  ) const;

private:

	/// information about the mode
	bool fullatom_;
	bool local_refine_;
	/// whether or not to initialize the viewer (for opengl)
	bool view_;
	// for outputting scorefiles
	std::map < std::string, core::Real > score_map_;

	// for scoring
	core::scoring::ScoreFunctionCOP docking_score_low_;
	core::scoring::ScoreFunctionCOP docking_score_high_;

	moves::MonteCarloOP mc_;

	//protocols
	SymDockingLowResOP docking_low_;
	SymDockingHiResOP docking_high_;

	std::string protocol_;

};

} // symmetric_docking
} // protocols
#endif //INCLUDED_protocols_symmetric_docking_SymDockProtocol_HH
