// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file docking_initialization_protocols
/// @brief initialization protocols for docking
/// @detailed
/// @author  Ingemar Andre


#ifndef INCLUDED_protocols_symmetrical_docking_SymDockingHiRes_HH
#define INCLUDED_protocols_symmetrical_docking_SymDockingHiRes_HH

// Package headers
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/pose/Pose.hh>

#include <core/options/option.hh>

#include <core/pack/task/PackerTask.hh>
#include <core/io/pdb/pose_io.hh>

#include <protocols/moves/MonteCarlo.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/MoverContainer.hh>
#include <protocols/moves/symmetry/SymPackRotamersMover.fwd.hh>
#include <protocols/moves/symmetry/SymRotamerTrialsMover.fwd.hh>
#include <protocols/moves/symmetry/SymMinMover.fwd.hh>
#include <protocols/moves/RigidBodyMover.hh>
#include <protocols/moves/TrialMover.hh>

// For symmetry
#include <core/conformation/symmetry/SymmetricConformation.fwd.hh>
#include <core/conformation/symmetry/SymmetryInfo.fwd.hh>

#include <string>

// option key includes

#include <core/options/keys/run.OptionKeys.gen.hh>
#include <core/options/keys/docking.OptionKeys.gen.hh>

namespace protocols {
namespace symmetric_docking {

class SymDockingHiRes;
typedef utility::pointer::owning_ptr< SymDockingHiRes > SymDockingHiResOP;
typedef utility::pointer::owning_ptr< SymDockingHiRes const > SymDockingHiResCOP;

class SymDockingHiRes : public moves::Mover
{
	typedef core::Real Real;
	typedef core::conformation::symmetry::SymmetricConformation SymmetricConformation;
	typedef core::conformation::symmetry::SymmetryInfo SymmetryInfo;


public:

	// default constructor
	SymDockingHiRes();

	// constructor with arguments
	SymDockingHiRes(
		core::scoring::ScoreFunctionOP scorefxn_in
	);

	moves::MoverOP clone() const;

	virtual ~SymDockingHiRes();


	void set_default( core::pose::Pose & pose ) {
		using namespace core::options;

		// SETS UP the stuff in pose
		(*scorefxn_)( pose );
		/// Now handled automatically.  scorefxn_->accumulate_residue_total_energies( pose );

		trans_magnitude_ = option[ OptionKeys::docking::dock_mcm_trans_magnitude ]();
		rot_magnitude_ = option[ OptionKeys::docking::dock_mcm_rot_magnitude ]();
		minimize_backbone_  = option[ OptionKeys::docking::symmetry::minimize_backbone ];
    minimize_sidechains_  = option[ OptionKeys::docking::symmetry::minimize_backbone ];

		temperature_ = 0.8;
		nb_list_ = true; /// not sure if this should be true or not
		repack_switch_ = true;
		repack_period_ = 8;
		energycut_ = 0.01; /// @todo: read in from elsewhere

		// use less cycles when running tests
		if (option[ OptionKeys::run::test_cycles ]() ) {
			four_cycles_=1;
			fortyfive_cycles_=10;
		} else {
			four_cycles_=4;
			fortyfive_cycles_=45;
		}


		// minimization
		loose_func_tol_ = 0.01;
		tight_func_tol_ = 0.01;
		minimization_threshold_ = 15.0;
		min_type_ = std::string( "dfpmin_armijo_nonmonotone" );
		set_default_mc( pose );
		set_default_move_map( pose );
		set_default_packers( pose );
		set_default_minimizer();

	}

	void set_default_mc( core::pose::Pose & pose );
	void set_default_move_map( core::pose::Pose & pose );
	void set_default_packers( core::pose::Pose & pose );
	void set_default_minimizer();
	void set_default_protocol( core::pose::Pose & pose );
	void set_min_type( std::string min_type_in );
	void set_repack( bool repack_switch);

	moves::MonteCarloOP get_mc() { return mc_; }

	// protocol functions
	virtual void apply( core::pose::Pose & pose );

	//void call_pack();  // Undefined function, commenting out to make python bindginds

	void dock_mcm_protocol( core::pose::Pose & pose );

	void classic_mcm_protocol(
  core::pose::Pose & pose,
  core::scoring::ScoreFunctionCOP scorefxn,
  protocols::moves::MonteCarloOP monteCarlo,
  core::Size num_cycles,
  core::Size repack_every_Nth
	);

	core::pose::Pose
	make_one_jump_pose( core::pose::Pose & pose );

private:
	// protocol stuff
	core::scoring::ScoreFunctionOP scorefxn_;
	core::kinematics::MoveMapOP movemap_;
	moves::symmetry::SymMinMoverOP min_mover_;
	moves::SequenceMoverOP docking_highres_protocol_mover_;
	moves::MonteCarloOP mc_;
	moves::symmetry::SymPackRotamersMoverOP pack_interface_repack_;
	moves::symmetry::SymRotamerTrialsMoverOP pack_rottrial_;

	// docking
	Real trans_magnitude_, rot_magnitude_;
	int four_cycles_, fortyfive_cycles_; ///< number of cycles to run
	bool chi_, bb_, nb_list_;
	bool repack_switch_; // master switch to turn repacking during docking on/off. Only makes sense if repack_period > 0

	// packing
	Real temperature_, energycut_;
	Size repack_period_;

	// minimization
	std::string min_type_;
	Real minimization_threshold_;
	Real loose_func_tol_, tight_func_tol_;
	bool minimize_backbone_;
	bool minimize_sidechains_;

	// auxillary
	bool benchmark_;

};

} // symmetrical_docking
} // protocols

#endif
