// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file SymDockingLowRes
/// @brief low resolution mode for symmetrical docking
/// @author Ingemar Andre


#ifndef INCLUDED_protocols_symmetric_docking_SymDockingLowRes_HH
#define INCLUDED_protocols_symmetric_docking_SymDockingLowRes_HH

// Package headers
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/pose/Pose.hh>

#include <protocols/moves/MinMover.hh>
#include <protocols/moves/MonteCarlo.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/MoverContainer.hh>
#include <protocols/moves/RigidBodyMover.hh>
#include <protocols/moves/TrialMover.hh>
#include <protocols/moves/RigidBodyMover.fwd.hh>

#include <core/options/option.hh>
#include <core/options/keys/docking.OptionKeys.gen.hh>

#include <string>

namespace protocols {
namespace symmetric_docking {

class SymDockingLowRes;
typedef utility::pointer::owning_ptr< SymDockingLowRes > SymDockingLowResOP;
typedef utility::pointer::owning_ptr< SymDockingLowRes const > SymDockingLowResCOP;


class SymDockingLowRes : public moves::Mover
{
	typedef core::Real Real;

public:

	// default constructor
	SymDockingLowRes() : Mover()
	{
		moves::Mover::type( "SymDockingLowRes" );
	}

	// constructor with arguments
	SymDockingLowRes(
		core::scoring::ScoreFunctionCOP scorefxn_in
	) : Mover(), scorefxn_(scorefxn_in)
	{
		moves::Mover::type( "SymDockingLowRes" );
	}

	moves::MoverOP clone() const {
		return new SymDockingLowRes( *this );
	}

	~SymDockingLowRes(){}

	void set_default( core::pose::Pose & pose ) {
		using namespace core::options;

		// sets up the stuff in pose
		(*scorefxn_)( pose );

		// cycles
		inner_cycles_ = option[ OptionKeys::docking::docking_centroid_inner_cycles ]();
		outer_cycles_ = option[ OptionKeys::docking::docking_centroid_outer_cycles ]();

		trans_magnitude_ = 0.7;
		rot_magnitude_ = 2.0;
		chi_ = false;
		bb_ = false;

		temperature_ = 0.8;
		nb_list_ = true; /// not sure if this should be true or not
		accept_rate_ = 0.0;

		set_default_mc( pose );
		set_default_move_map( pose );
	  set_default_protocol( pose );
	}

	void set_default_mc( core::pose::Pose & pose );
	void set_default_protocol( core::pose::Pose & pose );
	void set_default_move_map( core::pose::Pose & pose );

	moves::MonteCarloOP get_mc() { return mc_; }

	// protocol functions
	virtual void apply( core::pose::Pose & pose );
	void rigid_body_trial( core::pose::Pose & pose );

private:
	// protocol stuff
	core::scoring::ScoreFunctionCOP scorefxn_;
	core::kinematics::MoveMapOP movemap_;
	moves::MonteCarloOP mc_;
	moves::SequenceMoverOP docking_lowres_protocol_;
  moves::RigidBodyDofSeqPerturbMoverOP rb_mover_;

	// docking
	int inner_cycles_, outer_cycles_;
	Real trans_magnitude_, rot_magnitude_, accept_rate_;
	bool chi_, bb_, nb_list_;

	Real temperature_;

};

} // symmetric_docking
} // protocols

#endif
