// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

#ifndef INCLUDED_protocols_toolbox_Cluster_HH
#define INCLUDED_protocols_toolbox_Cluster_HH


#include <utility/vector1.hh>
#include <core/types.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <deque>

namespace protocols {
namespace toolbox {

class ClusterBase {
public:
  ClusterBase( core::Size dim ) :
    distance_( dim, dim, 0.0 ),
    dim_( dim )
	{};

  core::Real dist( core::Size i, core::Size j ) const {
    return distance_( i, j );
  }

  core::Real & dist( core::Size i, core::Size j ) {
    return distance_( i, j);
  }

	core::Size dim() const { return dim_; }

  void print_cluster_assignment( std::ostream& out ) const;

  typedef std::deque< core::Size > Cluster;
  typedef utility::vector1 < Cluster > ClusterList;
  typedef Cluster::const_iterator IntraClusterIterator;
  typedef ClusterList::const_iterator ClusterIterator;
  core::Size size() const {
    return clusterlist_.size();
  }

  Cluster const& cluster( core::Size i ) {
    return clusterlist_[ i ];
  }

  void show( std::ostream& out ) const;
  void read( std::istream& in );

protected:
  ClusterList clusterlist_;
  ObjexxFCL::FArray2D< core::Real > distance_;
  core::Size dim_;

};

class ClusterPhilStyle : public ClusterBase {
public:
  ClusterPhilStyle( core::Size dim, core::Real rad = 1.0 ) :
    ClusterBase( dim ),
    cluster_radius_ ( rad ),
		n_max_cluster_( 10 )
  {};

  void compute();

  void set_radius( core::Real setting ) {
    cluster_radius_ = setting;
  }

	void set_n_max_cluster( core::Size setting ) {
		n_max_cluster_ = setting;
	}
private:
  core::Real cluster_radius_;
	core::Size n_max_cluster_;
};



extern std::ostream& operator<< ( std::ostream& out, ClusterBase const& cl);
extern std::ostream& operator<< ( std::ostream& out, ClusterBase::ClusterList const& cl);
extern std::istream& operator>> ( std::istream& in, ClusterBase& cl);
extern std::istream& operator>> ( std::istream& in, ClusterBase::ClusterList& cl);



}
}

#endif
