// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/jd2/Job.hh
/// @brief  header file for ThreadingJob classes, part of August 2008 job distributor as planned at RosettaCon08.  This file is responsible for three ideas: "inner" jobs, "outer" jobs (with which the job distributor works) and job container (currently just typdefed in the .fwd.hh)
/// @author Steven Lewis smlewi@gmail.com

#ifndef INCLUDED_protocols_toolbox_DecoySetEvaluation_HH
#define INCLUDED_protocols_toolbox_DecoySetEvaluation_HH

#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray2Dp.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <utility/vector1.hh>
#include <core/types.hh>
#include <core/pose/Pose.hh>

namespace protocols {
namespace toolbox {

class DecoySetEvaluation {
public:
  DecoySetEvaluation();

  void reserve( core::Size n_decoys_ );
  void push_back( core::pose::Pose& pose );
  void rmsf( utility::vector1< core::Real >& results );

	core::Size n_decoys_max() const {
		return n_decoys_max_;
	}
  core::Size n_decoys() const {
    return n_decoys_;
  }
	core::Size n_atoms() const {
		return n_atoms_;
	}

	ObjexxFCL::FArray3D_double const& coords() const {
		return coords_;
	}

	//view on coords of structure i
	ObjexxFCL::FArray2Dp_double coords( core::Size i ) const {
		return ObjexxFCL::FArray2Dp_double( coords_( 1, 1, i ), 3, n_atoms_ );
	}

	void rmsf( ObjexxFCL::FArray1DB_double& result );
	void wRMSD( core::Real sigma2, core::Real tolerance, ObjexxFCL::FArray1DB_double& weights );
	void superimpose();

	core::pose::Pose const& ref_pose() {
		return ref_pose_;
	}

	void clear() {
		n_decoys_max_ = 0;
		n_decoys_ = 0;
		n_atoms_ = 0;
	}

private:
	void superimpose( ObjexxFCL::FArray1DB_double const& weights );
	core::Real rmsf( core::Size pos );

private:
	core::pose::Pose ref_pose_;
	ObjexxFCL::FArray1D_double COM;
  core::Size n_decoys_;
  core::Size n_atoms_;
  ObjexxFCL::FArray3D_double coords_;
  ObjexxFCL::FArray2D_double ref_structure_;
  core::Size n_decoys_max_;
  ObjexxFCL::FArray1D_double weights_;
};

}
}

#endif
