// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file /src/protocols/toolbox/PoseMetricCalculators/NonlocalContactsCalculator.hh
/// @brief
/// @author Florian Richter


#ifndef INCLUDED_protocols_toolbox_PoseMetricCalculators_NonlocalContactsCalculator_HH
#define INCLUDED_protocols_toolbox_PoseMetricCalculators_NonlocalContactsCalculator_HH

#include <core/pose/metrics/PoseMetricCalculatorBase.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/types.hh>
#include <core/util/MetricValue.fwd.hh>
#include <core/graph/Graph.fwd.hh>

#include <core/options/option.hh>

#include <utility/vector1.hh>

#include <set>


// option key includes

#include <core/options/keys/pose_metrics.OptionKeys.gen.hh>


namespace protocols{
namespace toolbox {
namespace PoseMetricCalculators {

class NonlocalContactsCalculator : public core::pose::metrics::EnergyDependentCalculator {

public:

  NonlocalContactsCalculator(
    core::Size min_sequence_separation = core::options::option[core::options::OptionKeys::pose_metrics::min_sequence_separation],
    core::Real contact_cutoffE = core::options::option[core::options::OptionKeys::pose_metrics::contact_cutoffE]
  );


  NonlocalContactsCalculator(
    std::set< core::Size > const & special_region,
    core::Size min_sequence_separation = core::options::option[core::options::OptionKeys::pose_metrics::min_sequence_separation],
    core::Real contact_cutoffE = core::options::option[core::options::OptionKeys::pose_metrics::contact_cutoffE]
  );

  NonlocalContactsCalculator(
    std::set< core::Size > const & special_region1,
    std::set< core::Size > const & special_region2,
    core::Size min_sequence_separation = core::options::option[core::options::OptionKeys::pose_metrics::min_sequence_separation],
    core::Real contact_cutoffE = core::options::option[core::options::OptionKeys::pose_metrics::contact_cutoffE]
  );



  core::pose::metrics::PoseMetricCalculatorOP clone() const {
    return new NonlocalContactsCalculator( special_region1_, special_region2_, min_seq_separation_, cutoffE_); };

protected:

  virtual void lookup( std::string const & key, core::util::MetricValueBase * valptr ) const;
  virtual std::string print( std::string const & key ) const;
  virtual void recompute( core::pose::Pose const & this_pose );


private:

  core::Size total_nlcontacts_;
  core::Size special_region1_nlcontacts_;
  core::Size special_region2_nlcontacts_;
  core::Size special_region1_intra_nlcontacts_;
  core::Size special_region1_to_other_nlcontacts_;
  core::Size region1_region2_nlcontacts_;

  utility::vector1< core::Size > residue_nlcontacts_;

  core::graph::GraphOP nlcontacts_graph_;

  //how far two residues need to be apart in sequence to count as nonlocal
  core::Size min_seq_separation_;

  //minimum energy between two residues to count as interacting
  core::Real cutoffE_;

  std::set< core::Size > special_region1_;
  std::set< core::Size > special_region2_;

};


} // namespace PoseMetricCalculators
} // namespace toolbox
} // namespace protocols

#endif
