// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file TopologyBroker
/// @brief  top-class (Organizer) of the TopologyBroker mechanism
/// @detailed responsibilities:
/// @author Oliver Lange


#ifndef INCLUDED_protocols_topology_broker_ConstraintClaimer_HH
#define INCLUDED_protocols_topology_broker_ConstraintClaimer_HH


// Unit Headers
#include <protocols/topology_broker/ConstraintClaimer.fwd.hh>

// Package Headers
#include <protocols/topology_broker/TopologyClaimer.hh>
#include <protocols/topology_broker/DofClaim.fwd.hh>
#include <core/scoring/constraints/ConstraintSet.hh>

// Project Headers
#include <core/pose/Pose.fwd.hh>

// ObjexxFCL Headers

// Utility headers
//#include <utility/io/izstream.hh>
//#include <utility/io/ozstream.hh>
//#include <utility/io/util.hh>
//#include <core/util/Tracer.hh>
//#include <core/options/option.hh>

#include <utility/pointer/ReferenceCount.hh>

//#include <core/options/option_macros.hh>

//// C++ headers
//#include <fstream>


// option key includes


namespace protocols {
namespace topology_broker {

class ConstraintClaimer : public TopologyClaimer {
	typedef TopologyClaimer Parent;
public:
	ConstraintClaimer(); //for factory
	ConstraintClaimer( std::string cst_file, std::string tag = "" );
	ConstraintClaimer( bool CmdFlag );

	virtual TopologyClaimerOP clone() const {
		return new ConstraintClaimer( *this );
	}

	virtual void generate_claims( DofClaims& );

	///@brief type() is specifying the output name of the TopologyClaimer
	virtual std::string type() const {
		return _static_type_name();
	}

	static std::string _static_type_name() {
		return "ConstraintClaimer";
	}

	virtual void new_decoy();

	virtual bool read_tag( std::string tag, std::istream & );

	virtual void add_constraints( core::pose::Pose& /*pose*/ );

private:
	std::string filename_;
	std::string cst_filename_;
	std::string tag_;
	mutable core::scoring::constraints::ConstraintSetOP constraints_;
	mutable core::pose::Pose constraint_ref_pose_;
	mutable std::string sequence_;

	///@brief true if constraints are active in centroid mode
	bool bCentroid_;

	///@brief true if constraints are active in full-atom mode
	bool bFullatom_;

	///@brief use constraints defined via command line
	bool bCmdFlag_;
}; //class ConstraintClaimer

}
}

#endif
