// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file TopologyBroker
/// @brief  top-class (Organizer) of the TopologyBroker mechanism
/// @detailed responsibilities:
/// @author Oliver Lange


#ifndef INCLUDED_protocols_topology_broker_CutBiasClaimer_HH
#define INCLUDED_protocols_topology_broker_CutBiasClaimer_HH


// Unit Headers
#include <protocols/topology_broker/CutBiasClaimer.fwd.hh>

// Package Headers
#include <protocols/topology_broker/TopologyClaimer.hh>

// Project Headers
//#include <core/pose/Pose.fwd.hh>

// ObjexxFCL Headers

// Utility headers
//#include <utility/io/izstream.hh>
//#include <utility/io/ozstream.hh>
//#include <utility/io/util.hh>
//#include <core/util/Tracer.hh>
//#include <core/options/option.hh>

//#include <core/options/option_macros.hh>
#include <protocols/jumping/SecondaryStructure.fwd.hh>

//// C++ headers
//#include <fstream>
#include <string>

// option key includes


namespace protocols {
namespace topology_broker {

class CutBiasClaimer : public virtual TopologyClaimer {
public:
	CutBiasClaimer(); //for factory
	CutBiasClaimer( utility::vector1< core::Real > const& );
	CutBiasClaimer( jumping::SecondaryStructure const& ss_def );

	virtual TopologyClaimerOP clone() const {
		return new CutBiasClaimer( *this );
	}

	virtual void generate_claims( DofClaims& ) {};

	///@brief read definition of Claimer from setup file, i.e., a CLAIMER <type> ... END_CLAIMER block
	virtual void read( std::istream & ) {};

	///@brief type() is specifying the output name of the TopologyClaimer
	virtual std::string type() const {
		return _static_type_name();
	}

	static std::string _static_type_name() {
		return "CutBiasClaimer";
	}

	virtual void manipulate_cut_bias( utility::vector1< core::Real >& /*cut_bias*/ );

protected:
private:
	utility::vector1< core::Real > cut_bias_;
}; //class CutBiasClaimer

}
}

#endif
