// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file TopologyBroker
/// @brief  top-class (Organizer) of the TopologyBroker mechanism
/// @detailed responsibilities:
/// @author Oliver Lange


#ifndef INCLUDED_protocols_topology_broker_StartStructClaimer_HH
#define INCLUDED_protocols_topology_broker_StartStructClaimer_HH


// Unit Headers
#include <protocols/topology_broker/StartStructClaimer.fwd.hh>
#include <protocols/topology_broker/FragmentClaimer.hh>

// Package Headers
#include <protocols/topology_broker/TopologyClaimer.hh>

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <core/kinematics/MoveMap.hh>



//#include <core/fragment/FragSet.hh>


// ObjexxFCL Headers

// Utility headers


//#include <utility/io/izstream.hh>
//#include <utility/io/ozstream.hh>
//#include <utility/io/util.hh>
//#include <core/util/Tracer.hh>
//#include <core/options/option.hh>

#include <utility/pointer/ReferenceCount.hh>

//#include <core/options/option_macros.hh>

//// C++ headers
//#include <fstream>
#include <string>

// option key includes


namespace protocols {
namespace topology_broker {

class StartStructClaimer : public virtual FragmentClaimer {
public:
	StartStructClaimer(); //for factory
	StartStructClaimer( core::pose::Pose const& /*idealized*/ );


	virtual TopologyClaimerOP clone() const {
		return new StartStructClaimer( *this );
	}

	///@brief type() is specifying the output name of the TopologyClaimer
	virtual std::string type() const {
		return _static_type_name();
	}

	///@brief overloaded to allow perturbation of start structure
	virtual void initialize_dofs( core::pose::Pose&, DofClaims const& init_claims, DofClaims& failed_to_init );

	static std::string _static_type_name() {
		return "StartStructClaimer";
	}

	virtual void new_decoy( core::pose::Pose const& );
	virtual void new_decoy( );

	virtual bool read_tag( std::string tag, std::istream & );

	virtual moves::MoverOP get_mover(	core::pose::Pose const& /*pose*/ ) const
	{ return NULL; }; /*does not provide mover*/

protected:
	void generate_init_frags( core::pose::Pose const& );
private:

	///@brief use the job input pose to get starting structure
	bool bUseInputPose_;

	///@brief perturb start torsions by gaussian()*perturb_
	core::Real perturb_;

}; //class StartStructClaimer

}
}

#endif
