// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file TopologyBroker
/// @brief  top-class (Organizer) of the TopologyBroker mechanism
/// @detailed responsibilities:
/// @author Oliver Lange

// Unit Headers
#include <protocols/topology_broker/TopologyClaimerFactory.hh>

// Package Headers
#include <protocols/topology_broker/DofClaim.hh>
#include <protocols/topology_broker/TopologyClaimer.hh>

// Project Headers
#include <core/pose/Pose.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/fragment/FragSet.hh>
#include <protocols/abinitio/FragmentMover.hh>
#include <protocols/jumping/JumpSetup.hh>

#include <protocols/topology_broker/RigidChunkClaimer.hh>
#include <protocols/topology_broker/ConstraintClaimer.hh>
#include <protocols/topology_broker/FragmentClaimer.hh>
#include <protocols/topology_broker/JumpClaimer.hh>
#include <protocols/topology_broker/SequenceClaimer.hh>
#include <protocols/topology_broker/MetalloClaimer.hh>
#include <protocols/topology_broker/TemplateJumpClaimer.hh>
#include <protocols/topology_broker/CoordConstraintClaimer.hh>
#include <protocols/topology_broker/StartStructClaimer.hh>
#include <protocols/topology_broker/CutBiasClaimer.hh>
#include <protocols/topology_broker/DensityScoringClaimer.hh>
#include <protocols/topology_broker/FoldandDockClaimer.hh>
#include <protocols/topology_broker/PseudocontactShiftEnergyController.hh>
#include <protocols/topology_broker/FibrilModelingClaimer.hh>
//#include <protocols/topology_broker/JumpClaimer.hh>


// ObjexxFCL Headers

// Utility headers
//#include <utility/io/izstream.hh>
//#include <utility/io/ozstream.hh>
//#include <utility/io/util.hh>
#include <core/util/Tracer.hh>
//#include <core/options/option.hh>

//// C++ headers
#include <fstream>

// option key includes

static core::util::Tracer tr("protocols.topo_broker",core::util::t_info);
//static numeric::random::RandomGenerator RG(18828234);

namespace protocols {
namespace topology_broker {

using namespace core;
TopologyClaimerFactory* TopologyClaimerFactory::instance_ = NULL ;

TopologyClaimerFactory const& TopologyClaimerFactory::get_instance() {
	if ( !instance_ ) instance_ = new TopologyClaimerFactory;
	return *instance_;
}

void
TopologyClaimerFactory::add_type( TopologyClaimerOP new_func ) {
	std::string type_name = new_func->type();
	claimer_types_[ type_name ] = new_func;
}

void
TopologyClaimerFactory::add_type( std::string const & type_name, TopologyClaimerOP new_func ) {
   claimer_types_[ type_name ] = new_func;
}

TopologyClaimerOP TopologyClaimerFactory::newTopologyClaimer( std::string const & type_name ) const {
	TopologyClaimerTypes::const_iterator iter = claimer_types_.find( type_name );
	if ( iter != claimer_types_.end() ) {
		return iter->second->clone();
	} else {
		utility_exit_with_message(
			type_name +
			" does not name a known TopologyClaimer --> " +
			"check spelling or register new TopologyClaimer type in TopologyClaimerFactory!"
		); // or should we be silent here and break later ?
		return NULL;
	}
}

TopologyClaimerFactory::TopologyClaimerFactory(void) {
  // initialization of functions which this factory knows how to instantiate
	add_type( new RigidChunkClaimer );
	add_type( new SequenceClaimer );
	add_type( new JumpClaimer );
	add_type( new FragmentClaimer );
	add_type( new ConstraintClaimer );
	add_type( new MetalloClaimer );
	add_type( new TemplateJumpClaimer );
	add_type( new CoordConstraintClaimer );
	add_type( new StartStructClaimer );
	add_type( new CutBiasClaimer );
	add_type( new DensityScoringClaimer );
	add_type( new PseudocontactShiftEnergyController );
	add_type( new FoldandDockClaimer );
	add_type( new FibrilModelingClaimer );

}


} //topology_broker
} //protocols
