// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file TopologyBroker
/// @brief  top-class (Organizer) of the TopologyBroker mechanism
/// @detailed responsibilities:
///           maintains list of ToplogyClaimerFactorys
///           maintains TopologyClaimerFactorys -- exclusive or non-exclusively markedup dofs like BackboneClaim, IntraResClaim, JumpClaim
///           generates FoldTree, MoveMap, and collects samplers provided by TopologyClaimerFactorys
/// @author Oliver Lange


#ifndef INCLUDED_protocols_topology_broker_TopologyClaimerFactory_HH
#define INCLUDED_protocols_topology_broker_TopologyClaimerFactory_HH


// Unit Headers
#include <protocols/topology_broker/DofClaim.hh>
//#include <protocols/topology_broker/TopologyClaimerFactory.fwd.hh>

// Package Headers

// Project Headers
#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>

//#include <core/kinematics/MoveMap.fwd.hh>

// ObjexxFCL Headers

// Utility headers
#include <utility/vector1.hh>
//#include <utility/io/izstream.hh>
//#include <utility/io/ozstream.hh>
//#include <utility/io/util.hh>
//#include <core/util/Tracer.hh>
//#include <core/options/option.hh>

#include <utility/pointer/ReferenceCount.hh>

//#include <core/options/option_macros.hh>

//// C++ headers
//#include <fstream>


// option key includes


namespace protocols {
namespace topology_broker {

class TopologyClaimerFactory {
public:
	static TopologyClaimerFactory const& get_instance();
	void add_type( std::string const& type_name, TopologyClaimerOP new_claimer );
	void add_type( TopologyClaimerOP new_claimer );
	TopologyClaimerOP newTopologyClaimer( std::string const& type_name ) const;

private:
	typedef std::map< std::string, TopologyClaimerOP > TopologyClaimerTypes;
	TopologyClaimerTypes claimer_types_;

private: //singleton - implementation
	TopologyClaimerFactory();
	static TopologyClaimerFactory* instance_;
}; //class TopologyClaimerFactory


}
}

#endif
