# :noTabs=true:
# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

# Big items:
# -HBonds do not print
# -Packing task setup is goofy.  Needs renaming and possibly new interface
# -Fold tree I/O to avoid magic numbers.
# +load doxygen brief and detailed tags into help

#TODO: find a way to INSTALL so that one can invoke iPython and the Rosetta library without having to be in the
#      install directory.  Preferably two solutions: 1-install to a network location and 2-install to a user account.
#      either way a user should just set some paths into environment variables and be done.

print 'Week 0: general testing ----------------------------------------------'
import sys
from rosetta import *

print Vector1([1, 2, 3, 4])
print Vector1([1, 2, 3, 4.5])
print Vector1(['a', 'b', 'c', 'd'])


print 'Week 1: Pose Geometry ----------------------------------------------'

print 'Testing Python bindings for Rosetta...'
print 'Init...'
rosetta.init()
print version()
# TODO: add copyright and JHU/Lyskov et al credits to version line
# TODO: also add a support email (pyrosetta-support@rosettacommons.org?)

print 'Creating Pose object...'
pose = Pose()

print 'Pose from PDB...'
#pose = Pose("test_in.pdb") #constructor isn't python friendly
pose_from_pdb(pose, "test_in.pdb")
# TODO: rename pose_from_pdb or make_pose_from_sequence to be parallel

print 'Building Pose from sequence...'
pose3 = Pose()
make_pose_from_sequence(pose3, "DSEEKFLRRIGRFGYGYGPYE",'centroid')
print pose3

pose4 = Pose()
make_pose_from_sequence(pose4, "ARNDCEQGHILKMFPSTWYV", 'fa_standard')


print 'Dump PDB...'
dump_pdb(pose, "_.pdb")

print 'accessing pose attributes'
print pose
# TODO: remove extra blank lines at end
print 'there are ', pose.total_residue(), 'residues in this pose object'
print 'phi of residue 5 is ', pose.phi(5)
print 'psi of residue 5 is ', pose.psi(5)

print 'set phi of residue 5 to -60'
pose.set_phi(1, -60)
print 'set psi of residue 5 to -50'
pose.set_psi(1, -50)

print 'accessing residue 5 from pose'
res5 = pose.residue(5)
print res5

print 'accessing atoms from residue 5'
at5N  = res5.atom('N')
at5CA = res5.atom("CA")
at5C  = res5.atom("C")

print at5N
# TODO: above should print atom type key not magic number
# 2/23/9: hm, not sure this is possible b/c atom does not know which AtomTypeSet to use!

print 'xyz of at5N:', at5N.xyz().x, at5N.xyz().y, at5N.xyz().z
print 'norm of xyz at5N:', at5N.xyz().norm

print res5.atoms()  # <-- Still missing

atomN = AtomID(1,5)
atomCA = AtomID(2,5)
atomC = AtomID(3,5)
print 'bond length of N-CA in residue 5 is '
print pose.conformation().bond_length(atomN, atomCA)
print 'bond angle of N-CA-C in residue 5 is '
print pose.conformation().bond_angle(atomN, atomCA, atomC)
print 'setting bond length of N-CA in residue 5 to 1.5A '
pose.conformation().set_bond_length(atomN, atomCA, 1.5)
print 'setting bond angle of N-CA-C in residue 5 to 90 '
pose.conformation().set_bond_angle(atomN, atomCA, atomC, 90)
# TODO: make the above work with atom objects instead of atomIDs


print 'pose was generated from this pdb file: ', pose.pdb_info().name()
print 'pose numbering for chain A, residue 5, is ', pose.pdb_info().pdb2pose('A',5)
print 'pdb chain letter and residue number for residue 5, is ', pose.pdb_info().pose2pdb(5)
# TODO: pdb_info.* does not tab-complete


print 'Week 2: Scoring ----------------------------------------------'
pose_from_pdb(pose, "test_fragments.pdb")

print 'Creating standard fullatom score function and scoring'
scorefxn = create_score_function('standard')
scorefxn(pose)

print 'Creating standard centroid score function and scoring'
scorefxn = create_score_function('score3')
scorefxn(pose)

print 'Creating standard score function with patch and scoring'
scorefxn = create_score_function_ws_patch("standard", "score12")
scorefxn(pose)
print 'Creating standard score from scratch'
scorefxn = ScoreFunction()

print 'Adjusting weights and scoring'
scorefxn.set_weight(fa_atr, 1)
scorefxn.set_weight(fa_pair, 1)
scorefxn.set_weight(fa_rep, 1)
scorefxn(pose)

print 'weight for fa_atr set to: ', scorefxn.get_weight(fa_atr)
print scorefxn
print 'Score break down for pose...'
scorefxn.show(pose)

print 'all residue energies are'
print pose.energies().show()
print 'weighted energies for residue 5'
print pose.energies().show(5)
#TODO: align headers in .show statements above
#TODO: add TOTAL residue energy column (weighted)

#old way:
weights = pose.energies().weights()
print pose.energies().residue_total_energies(5).weighted_string_of( weights )
print 'fa_atr of residue 5'
print weights[fa_atr] * pose.energies().residue_total_energies(5)[fa_atr ]
print "fa_atr for residue 5: ", pose.energies().residue_total_energies(5)[fa_atr]

print 'manually calculating 2body context-independent energies between residues 4 and 5'
rsd1 = pose.residue(4);
rsd2 = pose.residue(5);

emap = TwoBodyEMapVector()
scorefxn.eval_ci_2b( rsd1, rsd2, pose, emap );

print "fa_atr between 1 and 2: ", emap[fa_atr]
print "fa_pair between 1 and 2: ", emap[fa_pair]
print "fa_rep between 1 and 2: ", emap[fa_rep]

score_types = []
for i in range(1, rosetta.core.scoring.end_of_score_type_enumeration+1):
    ii = rosetta.core.scoring.ScoreType(i)
    if weights[ii] != 0: score_types.append(ii)

for i in range(1, rosetta.core.scoring.end_of_score_type_enumeration+1):
    print rosetta.core.scoring.ScoreType(i),   # This print only number, is this correct???  (no!)
#print
#TAB-COMPLETION gives this:
#rosetta.core.scoring.ScoreType.[tab]
# TODO-lowpriority: instead of using tab-completion, accomplish the above with:
# print rosetta.core.scoring.ScoreType

print 'identifying hydrogen bonds in structure'
hbond_set = rosetta.core.scoring.hbonds.HBondSet()
pose.update_residue_neighbors();
rosetta.core.scoring.hbonds.fill_hbond_set( pose, False, hbond_set )
hbond_set.show(pose)
# TODO: can we add an hbondset lookup by residue number?


print 'Week 3: Folding ----------------------------------------------'

print 'setting up a move map'
movemap = MoveMap()
print 'setting all backbone movement to true, and residue 10 to false'
movemap.set_bb(True)
movemap.set_bb(10,False)
print 'outputting movemap'
movemap.show(pose.total_residue())
# QUESTION: why does this need total_residue?  what happens if you give a bigger number??

print 'mover: SwitchResidueTypeSetMover, to centroid'
to_centroid = SwitchResidueTypeSetMover('centroid')
to_centroid.apply(pose)
print pose.residue(5)

print 'mover: SwitchResidueTypeSetMover, to fullatom'
to_fullatom = SwitchResidueTypeSetMover('fa_standard')
to_fullatom.apply(pose)
print pose.residue(5)

#print switch.get_name() # shouldn't this work by inheriting from Mover base class?? LATER
print to_fullatom 

print 'reading 3mer and 9mer fragment files'
pose_frag = Pose()
pose_from_pdb(pose_frag, "test_fragments.pdb")
fragset3mer = ConstantLengthFragSet(3, "test3_fragments")# "aatestA03_05.200_v1_3")
fragset9mer = ConstantLengthFragSet(9, "test9_fragments")# "aatestA09_05.200_v1_3")

# Sergey TODO something to avoid Seg Fault upon FileNotFound

print 'mover: ClassicFragmentMover, 3mer'
movemap.set_bb(1)
mover_3mer = ClassicFragmentMover(fragset3mer,movemap)
mover_3mer.apply(pose_frag)


print 'Week 4: Refinement ----------------------------------------------'

kT=1.0
n_moves=10

print 'mover: SmallMover'
movemap.set_bb(1)
smallmover = SmallMover(movemap,kT,n_moves)
smallmover = SmallMover()
smallmover.angle_max('L',50)
smallmover.apply(pose_frag)
print smallmover
# TODO: fix printout.  show mover params (temp, nmoves, anglemax) and last output status

# TODO: mover base class printout with name, last output status, brief description(?)

print 'mover: ShearMover'
shearmover = ShearMover(movemap,kT,n_moves)
shearmover = ShearMover()
shearmover.angle_max('E',50)
shearmover.apply(pose_frag)
print shearmover
#TODO: same as above

print 'mover: MinMover'
minmover = MinMover()
minmover.movemap(movemap)
minmover.score_function(scorefxn)
minmover.apply(pose_frag)

# currently crash!
minmover = MinMover(movemap,scorefxn,'linmin',0.5, True) #nblist mover was recent undefaulted
# the above crashes unless False changes to True -- what is this about?
# TODO: prefered solution is to overload the last argument to a default, valid value
minmover.apply(pose_frag)
minmover.min_type('dfpmin')  # set_mintype is no longer in C++!
minmover.apply(pose_frag)

#NEEDED: AbInitio [ERROR - OP], Relax [no bindings], Idealize[no bindings]

print 'mover: MonteCarlo'
mc = MonteCarlo(pose, scorefxn, kT)
mc.boltzmann(pose)

mc.reset(pose)
mc.boltzmann(pose)
smallmover.apply(pose)
mc.boltzmann(pose)
smallmover.apply(pose)
mc.boltzmann(pose)
print mc # TODO: this should tell the pose, scorefunction and temperature
mc.show_scores()
mc.show_counters()
mc.show_state()

print 'mover: ClassicAbinitio ERROR'
ab = ClassicAbinitio(fragset3mer, fragset9mer, movemap)
#ab.apply(pose) # Error!

print 'mover: SequenceMover'
seqmover = SequenceMover()
seqmover.add_mover(minmover)
seqmover.apply(pose)

print 'mover: TrialMover'
trialmover = TrialMover(mover_3mer, mc)
trialmover.apply(pose)
trialmover.num_accepts()
trialmover.acceptance_rate()
mc.show_state() # this should have breakdown by mover type now

print 'Week 5: Packing and Design ----------------------------------------------'

print 'mover: PackRotamersMover'
pose_from_pdb(pose,"test_in.pdb")
scorefxn = create_score_function('standard')
#task_pack = TaskFactory.create_packer_task(pose)
task_pack = standard_packer_task(pose) 
task_pack.restrict_to_repacking()
task_pack.nonconst_residue_task(5).prevent_repacking()
print task_pack
pack = PackRotamersMover( scorefxn, task_pack )
pack.apply(pose)

rotamer_trials = RotamerTrialsMover(scorefxn, task_pack)
rotamer_trials.apply(pose)

#TODO add task interface commands like:
#prevent_repacking(1,total_residue) or (res) or (True [=all])
#allow_repacking() # same argument options/overload
# ... needs discussion with Mini community...task is 'commutative'

#TODO add meaningful info to print pack
print pack

task_design = TaskFactory.create_packer_task(pose)
task_design.read_resfile("test_in.resfile") # TODO this hard-crashes if file is not a resfile
# BUG reported on jenkins machine: comments before 'start' line cause crash
print task_design
pack = PackRotamersMover( scorefxn, task_design )
pack.apply(pose)

#TaskFactory options
tf = standard_task_factory()
tf.push_back(RestrictToRepacking())

pr = PreventRepacking()
pr.include_residue(5)

tf.push_back(pr)

pack = PackRotamersMover( scorefxn )
pack.task_factory(tf)
pack.apply(pose)

print 'Week 6: Docking ----------------------------------------------------'

dock_p = Pose()
pose_from_pdb(dock_p, "test_dock.pdb")
dock_jump = 1
DockingProtocol().setup_foldtree(dock_p)
starting_p = Pose()
starting_p.assign(dock_p)

to_centroid.apply(dock_p)

dock_pert = RigidBodyPerturbMover(dock_jump, 3, 8)
dock_pert.apply(dock_p)

spin = RigidBodySpinMover( dock_jump )
spin.apply(dock_p)

slide_into_contact = DockingSlideIntoContact( dock_jump )
slide_into_contact.apply(dock_p)

docking_lowres = DockingLowRes()
docking_lowres.apply(dock_p)

DockingProtocol().recover_sidechains(dock_p, starting_p)

docking_highres = DockingHighRes()
docking_highres.apply(dock_p)

# NEEDED: access and print interface
# TODO: Fix print fold_tree to avoid -1/1 codes
# TODO: Make jump_num default to 1 in all docking movers

print 'Week 7: Fold tree and loop building --------------------------------------------------'
#NEEDED: Fold tree, getting, printing, setting jumps and cuts
#fold tree functions
existing_ft = pose.fold_tree()
print existing_ft

# I'm guessing on the below!!
ft = FoldTree()
ft.simple_tree(116)
ft.new_jump(30,50,40) # jump_begin, jump_end, cutpoint
print ft # FOLD_TREE  EDGE 1 30 -1  EDGE 30 40 -1  EDGE 30 50 1  EDGE 50 116 -1  EDGE 50 41 -1
ft.check_fold_tree()
print ft.nres(), ft.size(), ft.root() # 116, 5, 1

ft.clear()
ft.add_edge(1,30,-1)
ft.add_edge(30,40,-1)
ft.add_edge(30,50,1)
ft.add_edge(50,41,-1)
ft.add_edge(50,116,-1)
ft.check_fold_tree()
print ft

ft.clear()
# This function no longer present in C++
# ft.simple_fold_tree()
# ft.add_jump(30,50,40)
print ft

#loop functions
loop_p = Pose()
pose_from_pdb(loop_p, "test_in.pdb")

loop = Loop(70,80,75)
loops = Loops()
loops.add_loop(loop)

set_single_loop_fold_tree(loop_p, loop)

print loop_p.fold_tree()

#recover_sidechain = ReturnSidechainMover(loop_p)
#to_centroid.apply(loop_p)

#fragset3mer = ConstantLengthFragSet(3, "test_in3_fragments")
#scorefxn = create_score_function_ws_patch('cen_std', 'score4L')
#scorefxn(loop_p)
#loop_perturb = LoopMover_Perturb_CCD(loops, scorefxn, fragset3mer)
#loop_perturb.apply(p)
#loop_perturb.model_loop(loop_p, loop)

#recover_sidechain.apply(loop_p)

scorefxn = create_score_function_ws_patch('standard', 'score12')
scorefxn(loop_p)
loop_refine = LoopMover_Refine_CCD( loops, scorefxn )
loop_refine.max_inner_cycles(10)
loop_refine.apply(loop_p)

#NEEDED: AtomTree?
#%run loops.py
#import loops

print 'Week 8: Other movers and protocols --------------------------------------'

print 'testing ClassicRelax' 
relax_p = Pose()
pose_from_pdb(relax_p, "test_in.pdb")
scorefxn = create_score_function_ws_patch('standard', 'score12')
relax = ClassicRelax(scorefxn)
relax.set_lj_ramp_cycles(3)
relax.set_lj_ramp_inner_cycles(3)
relax.set_stage2_cycles(10)
relax.set_stage3_cycles(10)
relax.apply(relax_p)

print 'testing ligand modeling' 
params_list = Vector1(['ligand.params'])
res_set = generate_nonstandard_residue_set(params_list)
ligand_p = Pose()
pose_from_pdb(ligand_p, res_set, "ligand_test.pdb")

scorefxn = create_score_function("ligand")
scorefxn(ligand_p)

print 'testing DNA modeling' 
dna_p = Pose()
pose_from_pdb(dna_p, "dna_test.pdb")

scorefxn = create_score_function("dna")
scorefxn(dna_p)

print 'Advanced topics wish list ---------------------------------------------------'
#NEEDED: Surface object, ddG mode, kinematic loop closing and backrub, loop regrow
#NEEDED: how to create fragments from sequence?? [Monica says this is too hard right now, maybe next year]
#MAYBE NEEDED: more complex version of job destributor?
#NEEDED: constraints object

print; print; print
print version(); print


#    def main(args):
#if __name__ == "__main__": main(sys.argv)



# ----------------------------------------------------------

