// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#include "boost/python.hpp"

#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/scoring/NeighborList.hh>
#include <core/scoring/SecondaryStructureWeights.hh>
#include <core/scoring/Energies.hh>


#include <core/pose/Pose.hh>
#include <core/io/pdb/pose_io.hh>
#include <core/scoring/ScoreFunction.hh>

namespace bp = boost::python;


::core::scoring::ScoreFunction create_scoring_function(::std::string const & s)
{
	::core::scoring::ScoreFunction sf;
	::core::scoring::ScoreFunctionOP op = ::core::scoring::ScoreFunctionFactory::create_score_function(s);
	sf = *op;
	return sf;
}

::core::scoring::ScoreFunction create_scoring_function_ws_patch(::std::string const & s, ::std::string const & p)
{
	::core::scoring::ScoreFunction sf;
	::core::scoring::ScoreFunctionOP op = ::core::scoring::ScoreFunctionFactory::create_score_function(s, p);
	sf = *op;
	return sf;
}

void qqqqq_test_scoring(core::pose::Pose & pose, core::scoring::ScoreFunction &sf)
{
	sf(pose);
	pose.energies().residue_total_energies(5);
}

void qqqqq_test_scoring2(core::pose::Pose & pose)
{
	core::scoring::ScoreFunction scorefxn;
	scorefxn(pose);
	pose.energies().residue_total_energies(1);
	// rosetta.core.scoring.qqqqq_test_scoring
}

void qqqqq_test_scoring3()
{
	core::pose::Pose pose;
	core::io::pdb::pose_from_pdb(pose, "test_in.pdb");
	core::scoring::ScoreFunctionOP scorefxn = core::scoring::ScoreFunctionFactory::create_score_function("score13");

	(*scorefxn)(pose);
	pose.energies().residue_total_energies(1);
}



//BOOST_PYTHON_FUNCTION_OVERLOADS(create_scoring_function_overloads, create_scoring_function, 1, 2)


void wrap__scoring__by_hand()
{
    bp::def("qqqqq_test_scoring", qqqqq_test_scoring);
    bp::def("qqqqq_test_scoring2", qqqqq_test_scoring2);
    bp::def("qqqqq_test_scoring3", qqqqq_test_scoring3);

    bp::def("create_score_function", create_scoring_function);
    bp::def("create_score_function_ws_patch", create_scoring_function_ws_patch);


    bp::implicitly_convertible< core::scoring::ScoreFunction const &, core::scoring::ScoreFunctionInfo >();

    bp::implicitly_convertible< utility::pointer::owning_ptr< ::core::scoring::ScoreFunction >
                              , utility::pointer::owning_ptr< ::core::scoring::ScoreFunction const > >();
    bp::implicitly_convertible< utility::pointer::owning_ptr< ::core::scoring::NeighborList >
                              , utility::pointer::owning_ptr< ::core::scoring::NeighborList const > >();
    bp::implicitly_convertible< utility::pointer::owning_ptr< ::core::scoring::ScoreFunctionInfo >
                              , utility::pointer::owning_ptr< ::core::scoring::ScoreFunctionInfo const > >();
    bp::implicitly_convertible< utility::pointer::owning_ptr< ::core::scoring::SecondaryStructureWeights >
                              , utility::pointer::owning_ptr< ::core::scoring::SecondaryStructureWeights const > >();

}
