// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
#include "boost/python.hpp"

#include "numeric/xyzVector.hh"
#include "numeric/xyzTriple.hh"
#include "numeric/xyzMatrix.hh"
#include "numeric/Quaternion.hh"
#include "numeric/BodyPosition.hh"

// #include "numeric/Octree.hh"
// #include "core/util/AtomOctree.hh"

#include "core/conformation/Atom.hh"

#include <vector>

namespace bp = boost::python;
using namespace numeric;
using std::size_t;
using std::vector;
// using core::util::AtomOctree;
// using core::util::AtomOctreeBase;

typedef bp::return_value_policy< bp::reference_existing_object > CP_REF;
typedef bp::return_value_policy< bp::copy_const_reference >      CP_CCR;
typedef bp::return_value_policy< bp::copy_non_const_reference >  CP_CNCR;

template<class T>
void instantiate_numeric_funs()
{

  { xyzVector<T>   (*t)( xyzMatrix<T> const &, xyzVector<T> const &) = &(operator *); }
  { xyzVector<T>   (*t)( xyzMatrix<T> const &, xyzVector<T> const &) = &product; }
  { xyzVector<T> & (*t)( xyzMatrix<T> const &, xyzVector<T>       &) = &inplace_product; }
  { xyzVector<T>   (*t)( xyzMatrix<T> const &, xyzVector<T> const &) = &transpose_product; }
  { xyzVector<T> & (*t)( xyzMatrix<T> const &, xyzVector<T>       &) = &inplace_transpose_product; }
  { xyzMatrix<T>   (*t)( xyzVector<T> const &, xyzVector<T> const &) = &outer_product; }
  { xyzMatrix<T>   (*t)( xyzVector<T> const & ) = &projection_matrix; }
  { xyzMatrix<T>   (*t)( xyzVector<T> const &, T const & ) = &rotation_matrix; }
  { xyzMatrix<T>   (*t)( xyzVector<T> const &, T const & ) = &rotation_matrix_radians; }
  { xyzMatrix<T>   (*t)( xyzVector<T> const &, T const & ) = &rotation_matrix_degrees; }
  { xyzMatrix<T>   (*t)( T const & ) = &x_rotation_matrix; }
  { xyzMatrix<T>   (*t)( T const & ) = &x_rotation_matrix_radians; }
  { xyzMatrix<T>   (*t)( T const & ) = &x_rotation_matrix_degrees; }
  { xyzMatrix<T>   (*t)( T const & ) = &y_rotation_matrix; }
  { xyzMatrix<T>   (*t)( T const & ) = &y_rotation_matrix_radians; }
  { xyzMatrix<T>   (*t)( T const & ) = &y_rotation_matrix_degrees; }
  { xyzMatrix<T>   (*t)( T const & ) = &z_rotation_matrix; }
  { xyzMatrix<T>   (*t)( T const & ) = &z_rotation_matrix_radians; }
  { xyzMatrix<T>   (*t)( T const & ) = &z_rotation_matrix_degrees; }
  { xyzVector<T>   (*t)( xyzMatrix<T> const &, T &) = &rotation_axis; }
  { xyzVector<T>   (*t)( xyzMatrix<T> const &, T const & ) = &eigenvalue_jacobi; }
  { xyzVector<T>   (*t)( xyzMatrix<T> const &, T const &, xyzMatrix<T> & ) = &eigenvector_jacobi; }
  { void (*t)( xyzMatrix< T > const &, int const, int const, xyzMatrix<T> & ) = &jacobi_rotation; }

}

typedef numeric::xyzVector<double> XYZ;

// template< class T, class ToXYZ >
// void wrap_octree(char * name) {
//   typedef bp::class_< Octree<T,ToXYZ> > OctreeExposer;
//   OctreeExposer exposer(name);
//   exposer.def( bp::init< XYZ, XYZ, double >() );
//   exposer.def( bp::init< vector<T> &, double >() );
//   exposer.def( "insert"   , &Octree<T,ToXYZ>::insert );
//   exposer.def( "closest"  , &Octree<T,ToXYZ>::closest, CP_REF() );
//   exposer.def( "neighbors", &Octree<T,ToXYZ>::neighbors );
//   exposer.def( "__len__"  , &Octree<T,ToXYZ>::size );
//
// }

struct AtomXYZ {
  XYZ const & operator()(core::conformation::Atom * a) { return a->xyz(); }
};

void wrap__numeric__by_hand() {

  instantiate_numeric_funs<double>();

  // wrap_octree<XYZ,numeric::internal::Ident<XYZ> >("numeric___Octree");
  // wrap_octree<core::conformation::Atom*,AtomXYZ >("numeric___AtomOctree");


  { //::numeric::Quaternion<double>
      typedef bp::class_< numeric::Quaternion<double> > Quaternion_double_exposer_t;
      Quaternion_double_exposer_t Quaternion_double_exposer = Quaternion_double_exposer_t( "Quaternion_double" );
      bp::scope Quaternion_double_scope( Quaternion_double_exposer );
      Quaternion_double_exposer.def( bp::init< >() );
      Quaternion_double_exposer.def( bp::init< double const &, double const &, double const &, double const &, bp::optional< bool > >(( bp::arg("w_a"), bp::arg("x_a"), bp::arg("y_a"), bp::arg("z_a"), bp::arg("precise")=(bool const)(true) )) );
      { //::numeric::Quaternion<double>::I

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> const & ( *I_function_type )(  );

          Quaternion_double_exposer.def(
              "I"
              , I_function_type( &::numeric::Quaternion<double>::I )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::apply

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*apply_function_type )( ::numeric::Quaternion<double> const &,bool const ) ;

          Quaternion_double_exposer.def(
              "apply"
              , apply_function_type( &::numeric::Quaternion<double>::apply )
              , ( bp::arg("q"), bp::arg("precise")=(bool const)(true) )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::axis

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*axis_function_type )(  ) const;

          Quaternion_double_exposer.def(
              "axis"
              , axis_function_type( &::numeric::Quaternion<double>::axis )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::axis

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*axis_function_type )( ::numeric::xyzVector<double> & ) const;

          Quaternion_double_exposer.def(
              "axis"
              , axis_function_type( &::numeric::Quaternion<double>::axis )
              , ( bp::arg("u") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::conjugate

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*conjugate_function_type )(  ) ;

          Quaternion_double_exposer.def(
              "conjugate"
              , conjugate_function_type( &::numeric::Quaternion<double>::conjugate )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::dot

          typedef numeric::Quaternion<double> exported_class_t;
          typedef double ( exported_class_t::*dot_function_type )( ::numeric::Quaternion<double> const & ) const;

          Quaternion_double_exposer.def(
              "dot"
              , dot_function_type( &::numeric::Quaternion<double>::dot )
              , ( bp::arg("q") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::dot_product

          typedef numeric::Quaternion<double> exported_class_t;
          typedef double ( exported_class_t::*dot_product_function_type )( ::numeric::Quaternion<double> const & ) const;

          Quaternion_double_exposer.def(
              "dot_product"
              , dot_product_function_type( &::numeric::Quaternion<double>::dot_product )
              , ( bp::arg("q") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::identity

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> ( *identity_function_type )(  );

          Quaternion_double_exposer.def(
              "identity"
              , identity_function_type( &::numeric::Quaternion<double>::identity )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::invert

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*invert_function_type )(  ) ;

          Quaternion_double_exposer.def(
              "invert"
              , invert_function_type( &::numeric::Quaternion<double>::invert )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::is_normalized

          typedef numeric::Quaternion<double> exported_class_t;
          typedef bool ( exported_class_t::*is_normalized_function_type )( double const & ) const;

          Quaternion_double_exposer.def(
              "is_normalized"
              , is_normalized_function_type( &::numeric::Quaternion<double>::is_normalized )
              , ( bp::arg("tol")=numeric::NumericTraits<double>::quaternion_tolerance() )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::left_multiply_by

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*left_multiply_by_function_type )( ::numeric::Quaternion<double> const &,bool const ) ;

          Quaternion_double_exposer.def(
              "left_multiply_by"
              , left_multiply_by_function_type( &::numeric::Quaternion<double>::left_multiply_by )
              , ( bp::arg("q"), bp::arg("precise")=(bool const)(true) )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::left_multiply_by_inverse_of

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*left_multiply_by_inverse_of_function_type )( ::numeric::Quaternion<double> const &,bool const ) ;

          Quaternion_double_exposer.def(
              "left_multiply_by_inverse_of"
              , left_multiply_by_inverse_of_function_type( &::numeric::Quaternion<double>::left_multiply_by_inverse_of )
              , ( bp::arg("q"), bp::arg("precise")=(bool const)(true) )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::normalize

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*normalize_function_type )(  ) ;

          Quaternion_double_exposer.def(
              "normalize"
              , normalize_function_type( &::numeric::Quaternion<double>::normalize )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::normalize_if_needed

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*normalize_if_needed_function_type )( double const & ) ;

          Quaternion_double_exposer.def(
              "normalize_if_needed"
              , normalize_if_needed_function_type( &::numeric::Quaternion<double>::normalize_if_needed )
              , ( bp::arg("tol")=numeric::NumericTraits<double>::quaternion_tolerance() )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::not_normalized

          typedef numeric::Quaternion<double> exported_class_t;
          typedef bool ( exported_class_t::*not_normalized_function_type )( double const & ) const;

          Quaternion_double_exposer.def(
              "not_normalized"
              , not_normalized_function_type( &::numeric::Quaternion<double>::not_normalized )
              , ( bp::arg("tol")=numeric::NumericTraits<double>::quaternion_tolerance() )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::right_multiply_by

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*right_multiply_by_function_type )( ::numeric::Quaternion<double> const &,bool const ) ;

          Quaternion_double_exposer.def(
              "right_multiply_by"
              , right_multiply_by_function_type( &::numeric::Quaternion<double>::right_multiply_by )
              , ( bp::arg("q"), bp::arg("precise")=(bool const)(true) )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::right_multiply_by_inverse_of

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*right_multiply_by_inverse_of_function_type )( ::numeric::Quaternion<double> const &,bool const ) ;

          Quaternion_double_exposer.def(
              "right_multiply_by_inverse_of"
              , right_multiply_by_inverse_of_function_type( &::numeric::Quaternion<double>::right_multiply_by_inverse_of )
              , ( bp::arg("q"), bp::arg("precise")=(bool const)(true) )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::swap

          typedef numeric::Quaternion<double> exported_class_t;
          typedef void ( exported_class_t::*swap_function_type )( ::numeric::Quaternion<double> & ) ;

          Quaternion_double_exposer.def(
              "swap"
              , swap_function_type( &::numeric::Quaternion<double>::swap )
              , ( bp::arg("q") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::Quaternion<double>::to_identity

          typedef numeric::Quaternion<double> exported_class_t;
          typedef ::numeric::Quaternion<double> & ( exported_class_t::*to_identity_function_type )(  ) ;

          Quaternion_double_exposer.def(
              "to_identity"
              , to_identity_function_type( &::numeric::Quaternion<double>::to_identity )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      Quaternion_double_exposer.staticmethod( "I" );
      Quaternion_double_exposer.staticmethod( "identity" );
      { //property "w"[fget=::numeric::Quaternion<double>::w]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double const & ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "w"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::w )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "x"[fget=::numeric::Quaternion<double>::x]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double const & ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "x"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::x )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "y"[fget=::numeric::Quaternion<double>::y]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double const & ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "y"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::y )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "z"[fget=::numeric::Quaternion<double>::z]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double const & ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "z"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::z )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "w_squared"[fget=::numeric::Quaternion<double>::w_squared]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "w_squared"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::w_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "x_squared"[fget=::numeric::Quaternion<double>::x_squared]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "x_squared"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::x_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "y_squared"[fget=::numeric::Quaternion<double>::y_squared]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "y_squared"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::y_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "z_squared"[fget=::numeric::Quaternion<double>::z_squared]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "z_squared"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::z_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "norm"[fget=::numeric::Quaternion<double>::norm]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "norm"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::norm )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "norm_squared"[fget=::numeric::Quaternion<double>::norm_squared]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "norm_squared"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::norm_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "norm_error"[fget=::numeric::Quaternion<double>::norm_error]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "norm_error"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::norm_error )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "norm_squared_error"[fget=::numeric::Quaternion<double>::norm_squared_error]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "norm_squared_error"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::norm_squared_error )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "magnitude"[fget=::numeric::Quaternion<double>::magnitude]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "magnitude"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::magnitude )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "magnitude_squared"[fget=::numeric::Quaternion<double>::magnitude_squared]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "magnitude_squared"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::magnitude_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "magnitude_error"[fget=::numeric::Quaternion<double>::magnitude_error]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "magnitude_error"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::magnitude_error )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "magnitude_squared_error"[fget=::numeric::Quaternion<double>::magnitude_squared_error]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "magnitude_squared_error"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::magnitude_squared_error )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "angle"[fget=::numeric::Quaternion<double>::angle]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "angle"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::angle )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "conjugated"[fget=::numeric::Quaternion<double>::conjugated]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef ::numeric::Quaternion<double> ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "conjugated"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::conjugated )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "inverse"[fget=::numeric::Quaternion<double>::inverse]

          typedef numeric::Quaternion<double> fget_class_t;

          typedef ::numeric::Quaternion<double> ( fget_class_t::*fget )(  ) const;

          Quaternion_double_exposer.add_property(
              "inverse"
              , bp::make_function(
                    fget( &::numeric::Quaternion<double>::inverse )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      Quaternion_double_exposer.def( bp::self != bp::self );
      Quaternion_double_exposer.def( bp::self * bp::self );
      Quaternion_double_exposer.def( bp::self == bp::self );

	  Quaternion_double_exposer.def( bp::self_ns::str( bp::self ) );

  }

  { //::numeric::xyzMatrix<double>
      typedef bp::class_< numeric::xyzMatrix<double> > xyzMatrix_double_exposer_t;
      xyzMatrix_double_exposer_t xyzMatrix_double_exposer = xyzMatrix_double_exposer_t( "xyzMatrix" ); // "numeric___xyzMatrix_double"
      bp::scope xyzMatrix_double_scope( xyzMatrix_double_exposer );
      xyzMatrix_double_exposer.def( bp::init< >() );
      xyzMatrix_double_exposer.def( bp::init< double const & >(( bp::arg("t") )) );
      { //::numeric::xyzMatrix<double>::I

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> const & ( *I_function_type )(  );

          xyzMatrix_double_exposer.def(
              "I"
              , I_function_type( &::numeric::xyzMatrix<double>::I )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::add_diagonal

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*add_diagonal_function_type )( double const &,double const &,double const & ) ;

          xyzMatrix_double_exposer.def(
              "add_diagonal"
              , add_diagonal_function_type( &::numeric::xyzMatrix<double>::add_diagonal )
              , ( bp::arg("xx_a"), bp::arg("yy_a"), bp::arg("zz_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::clear

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*clear_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "clear"
              , clear_function_type( &::numeric::xyzMatrix<double>::clear )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::col

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*col_function_type )( int const ) const;

          xyzMatrix_double_exposer.def(
              "col"
              , col_function_type( &::numeric::xyzMatrix<double>::col )
              , ( bp::arg("i") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::col

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*col_function_type )( int const,::numeric::xyzVector<double> const & ) ;

          xyzMatrix_double_exposer.def(
              "col"
              , col_function_type( &::numeric::xyzMatrix<double>::col )
              , ( bp::arg("i"), bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::col_x

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*col_x_function_type )(  ) const;

          xyzMatrix_double_exposer.def(
              "col_x"
              , col_x_function_type( &::numeric::xyzMatrix<double>::col_x )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::col_x

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*col_x_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzMatrix_double_exposer.def(
              "col_x"
              , col_x_function_type( &::numeric::xyzMatrix<double>::col_x )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::col_y

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*col_y_function_type )(  ) const;

          xyzMatrix_double_exposer.def(
              "col_y"
              , col_y_function_type( &::numeric::xyzMatrix<double>::col_y )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::col_y

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*col_y_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzMatrix_double_exposer.def(
              "col_y"
              , col_y_function_type( &::numeric::xyzMatrix<double>::col_y )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::col_z

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*col_z_function_type )(  ) const;

          xyzMatrix_double_exposer.def(
              "col_z"
              , col_z_function_type( &::numeric::xyzMatrix<double>::col_z )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::col_z

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*col_z_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzMatrix_double_exposer.def(
              "col_z"
              , col_z_function_type( &::numeric::xyzMatrix<double>::col_z )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::cols

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> ( *cols_function_type )( double const &,double const &,double const &,double const &,double const &,double const &,double const &,double const &,double const & );

          xyzMatrix_double_exposer.def(
              "cols"
              , cols_function_type( &::numeric::xyzMatrix<double>::cols )
              , ( bp::arg("xx_a"), bp::arg("yx_a"), bp::arg("zx_a"), bp::arg("xy_a"), bp::arg("yy_a"), bp::arg("zy_a"), bp::arg("xz_a"), bp::arg("yz_a"), bp::arg("zz_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::diag

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> ( *diag_function_type )( double const &,double const &,double const & );

          xyzMatrix_double_exposer.def(
              "diag"
              , diag_function_type( &::numeric::xyzMatrix<double>::diag )
              , ( bp::arg("xx_a"), bp::arg("yy_a"), bp::arg("zz_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::identity

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> ( *identity_function_type )(  );

          xyzMatrix_double_exposer.def(
              "identity"
              , identity_function_type( &::numeric::xyzMatrix<double>::identity )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      xyzMatrix_double_exposer.def( bp::self *= bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self += bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self -= bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self /= bp::other< double >() );
      { //::numeric::xyzMatrix<double>::row

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*row_function_type )( int const ) const;

          xyzMatrix_double_exposer.def(
              "row"
              , row_function_type( &::numeric::xyzMatrix<double>::row )
              , ( bp::arg("i") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::row

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*row_function_type )( int const,::numeric::xyzVector<double> const & ) ;

          xyzMatrix_double_exposer.def(
              "row"
              , row_function_type( &::numeric::xyzMatrix<double>::row )
              , ( bp::arg("i"), bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::row_x

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*row_x_function_type )(  ) const;

          xyzMatrix_double_exposer.def(
              "row_x"
              , row_x_function_type( &::numeric::xyzMatrix<double>::row_x )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::row_x

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*row_x_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzMatrix_double_exposer.def(
              "row_x"
              , row_x_function_type( &::numeric::xyzMatrix<double>::row_x )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::row_y

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*row_y_function_type )(  ) const;

          xyzMatrix_double_exposer.def(
              "row_y"
              , row_y_function_type( &::numeric::xyzMatrix<double>::row_y )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::row_y

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*row_y_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzMatrix_double_exposer.def(
              "row_y"
              , row_y_function_type( &::numeric::xyzMatrix<double>::row_y )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::row_z

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*row_z_function_type )(  ) const;

          xyzMatrix_double_exposer.def(
              "row_z"
              , row_z_function_type( &::numeric::xyzMatrix<double>::row_z )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::row_z

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*row_z_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzMatrix_double_exposer.def(
              "row_z"
              , row_z_function_type( &::numeric::xyzMatrix<double>::row_z )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::rows

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> ( *rows_function_type )( double const &,double const &,double const &,double const &,double const &,double const &,double const &,double const &,double const & );

          xyzMatrix_double_exposer.def(
              "rows"
              , rows_function_type( &::numeric::xyzMatrix<double>::rows )
              , ( bp::arg("xx_a"), bp::arg("xy_a"), bp::arg("xz_a"), bp::arg("yx_a"), bp::arg("yy_a"), bp::arg("yz_a"), bp::arg("zx_a"), bp::arg("zy_a"), bp::arg("zz_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::set_diagonal

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*set_diagonal_function_type )( double const &,double const &,double const & ) ;

          xyzMatrix_double_exposer.def(
              "set_diagonal"
              , set_diagonal_function_type( &::numeric::xyzMatrix<double>::set_diagonal )
              , ( bp::arg("xx_a"), bp::arg("yy_a"), bp::arg("zz_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::subtract_diagonal

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*subtract_diagonal_function_type )( double const &,double const &,double const & ) ;

          xyzMatrix_double_exposer.def(
              "subtract_diagonal"
              , subtract_diagonal_function_type( &::numeric::xyzMatrix<double>::subtract_diagonal )
              , ( bp::arg("xx_a"), bp::arg("yy_a"), bp::arg("zz_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::to_diag

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*to_diag_function_type )( double const &,double const &,double const & ) ;

          xyzMatrix_double_exposer.def(
              "to_diag"
              , to_diag_function_type( &::numeric::xyzMatrix<double>::to_diag )
              , ( bp::arg("xx_a"), bp::arg("yy_a"), bp::arg("zz_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::to_identity

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*to_identity_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "to_identity"
              , to_identity_function_type( &::numeric::xyzMatrix<double>::to_identity )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::transpose

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*transpose_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "transpose"
              , transpose_function_type( &::numeric::xyzMatrix<double>::transpose )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::xx

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*xx_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "xx"
              , xx_function_type( &::numeric::xyzMatrix<double>::xx )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::xy

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*xy_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "xy"
              , xy_function_type( &::numeric::xyzMatrix<double>::xy )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::xz

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*xz_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "xz"
              , xz_function_type( &::numeric::xyzMatrix<double>::xz )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::yx

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*yx_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "yx"
              , yx_function_type( &::numeric::xyzMatrix<double>::yx )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::yy

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*yy_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "yy"
              , yy_function_type( &::numeric::xyzMatrix<double>::yy )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::yz

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*yz_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "yz"
              , yz_function_type( &::numeric::xyzMatrix<double>::yz )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::zero

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef ::numeric::xyzMatrix<double> & ( exported_class_t::*zero_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "zero"
              , zero_function_type( &::numeric::xyzMatrix<double>::zero )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::zx

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*zx_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "zx"
              , zx_function_type( &::numeric::xyzMatrix<double>::zx )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::zy

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*zy_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "zy"
              , zy_function_type( &::numeric::xyzMatrix<double>::zy )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzMatrix<double>::zz

          typedef numeric::xyzMatrix<double> exported_class_t;
          typedef double & ( exported_class_t::*zz_function_type )(  ) ;

          xyzMatrix_double_exposer.def(
              "zz"
              , zz_function_type( &::numeric::xyzMatrix<double>::zz )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      xyzMatrix_double_exposer.staticmethod( "I" );
      xyzMatrix_double_exposer.staticmethod( "cols" );
      xyzMatrix_double_exposer.staticmethod( "diag" );
      xyzMatrix_double_exposer.staticmethod( "identity" );
      xyzMatrix_double_exposer.staticmethod( "rows" );
      { //property "xx"[fget=::numeric::xyzMatrix<double>::xx, fset=::numeric::xyzMatrix<double>::xx]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "xx"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::xx )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::xx )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "xy"[fget=::numeric::xyzMatrix<double>::xy, fset=::numeric::xyzMatrix<double>::xy]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "xy"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::xy )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::xy )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "xz"[fget=::numeric::xyzMatrix<double>::xz, fset=::numeric::xyzMatrix<double>::xz]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "xz"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::xz )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::xz )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "yx"[fget=::numeric::xyzMatrix<double>::yx, fset=::numeric::xyzMatrix<double>::yx]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "yx"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::yx )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::yx )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "yy"[fget=::numeric::xyzMatrix<double>::yy, fset=::numeric::xyzMatrix<double>::yy]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "yy"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::yy )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::yy )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "yz"[fget=::numeric::xyzMatrix<double>::yz, fset=::numeric::xyzMatrix<double>::yz]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "yz"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::yz )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::yz )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "zx"[fget=::numeric::xyzMatrix<double>::zx, fset=::numeric::xyzMatrix<double>::zx]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "zx"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::zx )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::zx )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "zy"[fget=::numeric::xyzMatrix<double>::zy, fset=::numeric::xyzMatrix<double>::zy]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "zy"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::zy )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::zy )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "zz"[fget=::numeric::xyzMatrix<double>::zz, fset=::numeric::xyzMatrix<double>::zz]

          typedef numeric::xyzMatrix<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzMatrix_double_exposer.add_property(
              "zz"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::zz )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzMatrix<double>::zz )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "is_zero"[fget=::numeric::xyzMatrix<double>::is_zero]

          typedef numeric::xyzMatrix<double> fget_class_t;

          typedef bool ( fget_class_t::*fget )(  ) const;

          xyzMatrix_double_exposer.add_property(
              "is_zero"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::is_zero )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "is_identity"[fget=::numeric::xyzMatrix<double>::is_identity]

          typedef numeric::xyzMatrix<double> fget_class_t;

          typedef bool ( fget_class_t::*fget )(  ) const;

          xyzMatrix_double_exposer.add_property(
              "is_identity"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::is_identity )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "det"[fget=::numeric::xyzMatrix<double>::det]

          typedef numeric::xyzMatrix<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzMatrix_double_exposer.add_property(
              "det"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::det )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "trace"[fget=::numeric::xyzMatrix<double>::trace]

          typedef numeric::xyzMatrix<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzMatrix_double_exposer.add_property(
              "trace"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::trace )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "transposed"[fget=::numeric::xyzMatrix<double>::transposed]

          typedef numeric::xyzMatrix<double> fget_class_t;

          typedef ::numeric::xyzMatrix<double> ( fget_class_t::*fget )(  ) const;

          xyzMatrix_double_exposer.add_property(
              "transposed"
              , bp::make_function(
                    fget( &::numeric::xyzMatrix<double>::transposed )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      xyzMatrix_double_exposer.def( bp::other< double >() != bp::self );
      xyzMatrix_double_exposer.def( bp::self != bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self != bp::self );
      xyzMatrix_double_exposer.def( bp::other< double >() * bp::self );
      xyzMatrix_double_exposer.def( bp::self * bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self * bp::self );
      xyzMatrix_double_exposer.def( bp::self * bp::other< numeric::xyzVector<double> >() );
      xyzMatrix_double_exposer.def( bp::other< double >() + bp::self );
      xyzMatrix_double_exposer.def( bp::self + bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self + bp::self );
      xyzMatrix_double_exposer.def( bp::other< double >() - bp::self );
      xyzMatrix_double_exposer.def( bp::self - bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self - bp::self );
      xyzMatrix_double_exposer.def( bp::self / bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::other< double >() < bp::self );
      xyzMatrix_double_exposer.def( bp::self < bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self < bp::self );
      xyzMatrix_double_exposer.def( bp::other< double >() <= bp::self );
      xyzMatrix_double_exposer.def( bp::self <= bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self <= bp::self );
      xyzMatrix_double_exposer.def( bp::other< double >() == bp::self );
      xyzMatrix_double_exposer.def( bp::self == bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self == bp::self );
      xyzMatrix_double_exposer.def( bp::other< double >() > bp::self );
      xyzMatrix_double_exposer.def( bp::self > bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self > bp::self );
      xyzMatrix_double_exposer.def( bp::other< double >() >= bp::self );
      xyzMatrix_double_exposer.def( bp::self >= bp::other< double >() );
      xyzMatrix_double_exposer.def( bp::self >= bp::self );

	  xyzMatrix_double_exposer.def( bp::self_ns::str( bp::self ) );
  }

  bp::implicitly_convertible< double const &, numeric::xyzMatrix<double> >();

  { //::numeric::xyzTriple<double>
      typedef bp::class_< numeric::xyzTriple<double> > xyzTriple_double_exposer_t;
      xyzTriple_double_exposer_t xyzTriple_double_exposer = xyzTriple_double_exposer_t( "xyzTriple" ); //"numeric___xyzTriple_double"
      bp::scope xyzTriple_double_scope( xyzTriple_double_exposer );
      xyzTriple_double_exposer.def( bp::init< >() );
      xyzTriple_double_exposer.def( bp::init< double const & >(( bp::arg("t") )) );
      xyzTriple_double_exposer.def( bp::init< double const &, double const &, double const & >(( bp::arg("x_a"), bp::arg("y_a"), bp::arg("z_a") )) );
      { //::numeric::xyzTriple<double>::assign

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*assign_function_type )( double const &,double const &,double const & ) ;

          xyzTriple_double_exposer.def(
              "assign"
              , assign_function_type( &::numeric::xyzTriple<double>::assign )
              , ( bp::arg("x_a"), bp::arg("y_a"), bp::arg("z_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::clear

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*clear_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "clear"
              , clear_function_type( &::numeric::xyzTriple<double>::clear )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::cross

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*cross_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "cross"
              , cross_function_type( &::numeric::xyzTriple<double>::cross )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::cross_product

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*cross_product_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "cross_product"
              , cross_product_function_type( &::numeric::xyzTriple<double>::cross_product )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::distance

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double ( exported_class_t::*distance_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "distance"
              , distance_function_type( &::numeric::xyzTriple<double>::distance )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::distance_squared

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double ( exported_class_t::*distance_squared_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "distance_squared"
              , distance_squared_function_type( &::numeric::xyzTriple<double>::distance_squared )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::dot

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double ( exported_class_t::*dot_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "dot"
              , dot_function_type( &::numeric::xyzTriple<double>::dot )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::dot_product

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double ( exported_class_t::*dot_product_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "dot_product"
              , dot_product_function_type( &::numeric::xyzTriple<double>::dot_product )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::equal_length

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*equal_length_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "equal_length"
              , equal_length_function_type( &::numeric::xyzTriple<double>::equal_length )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::inner_product

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double ( exported_class_t::*inner_product_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "inner_product"
              , inner_product_function_type( &::numeric::xyzTriple<double>::inner_product )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::is_normalized

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*is_normalized_function_type )(  ) const;

          xyzTriple_double_exposer.def(
              "is_normalized"
              , is_normalized_function_type( &::numeric::xyzTriple<double>::is_normalized )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::is_normalized

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*is_normalized_function_type )( double const & ) const;

          xyzTriple_double_exposer.def(
              "is_normalized"
              , is_normalized_function_type( &::numeric::xyzTriple<double>::is_normalized )
              , ( bp::arg("tol") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::is_unit

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*is_unit_function_type )(  ) const;

          xyzTriple_double_exposer.def(
              "is_unit"
              , is_unit_function_type( &::numeric::xyzTriple<double>::is_unit )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::is_unit

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*is_unit_function_type )( double const & ) const;

          xyzTriple_double_exposer.def(
              "is_unit"
              , is_unit_function_type( &::numeric::xyzTriple<double>::is_unit )
              , ( bp::arg("tol") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::longer

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*longer_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "longer"
              , longer_function_type( &::numeric::xyzTriple<double>::longer )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::longer_or_equal

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*longer_or_equal_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "longer_or_equal"
              , longer_or_equal_function_type( &::numeric::xyzTriple<double>::longer_or_equal )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::max

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*max_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "max"
              , max_function_type( &::numeric::xyzTriple<double>::max )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::min

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*min_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "min"
              , min_function_type( &::numeric::xyzTriple<double>::min )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::negate

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*negate_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "negate"
              , negate_function_type( &::numeric::xyzTriple<double>::negate )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::negated

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*negated_function_type )(  ) const;

          xyzTriple_double_exposer.def(
              "negated"
              , negated_function_type( &::numeric::xyzTriple<double>::negated )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::negated

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*negated_function_type )( ::numeric::xyzTriple<double> & ) const;

          xyzTriple_double_exposer.def(
              "negated"
              , negated_function_type( &::numeric::xyzTriple<double>::negated )
              , ( bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalize

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*normalize_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "normalize"
              , normalize_function_type( &::numeric::xyzTriple<double>::normalize )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalize

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*normalize_function_type )( double const & ) ;

          xyzTriple_double_exposer.def(
              "normalize"
              , normalize_function_type( &::numeric::xyzTriple<double>::normalize )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalize_any

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*normalize_any_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "normalize_any"
              , normalize_any_function_type( &::numeric::xyzTriple<double>::normalize_any )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalize_any

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*normalize_any_function_type )( double const & ) ;

          xyzTriple_double_exposer.def(
              "normalize_any"
              , normalize_any_function_type( &::numeric::xyzTriple<double>::normalize_any )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalize_or_zero

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*normalize_or_zero_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "normalize_or_zero"
              , normalize_or_zero_function_type( &::numeric::xyzTriple<double>::normalize_or_zero )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalize_or_zero

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*normalize_or_zero_function_type )( double const & ) ;

          xyzTriple_double_exposer.def(
              "normalize_or_zero"
              , normalize_or_zero_function_type( &::numeric::xyzTriple<double>::normalize_or_zero )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_function_type )( ::numeric::xyzTriple<double> & ) const;

          xyzTriple_double_exposer.def(
              "normalized"
              , normalized_function_type( &::numeric::xyzTriple<double>::normalized )
              , ( bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_function_type )( double const &,::numeric::xyzTriple<double> & ) const;

          xyzTriple_double_exposer.def(
              "normalized"
              , normalized_function_type( &::numeric::xyzTriple<double>::normalized )
              , ( bp::arg("length_a"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*normalized_function_type )(  ) const;

          xyzTriple_double_exposer.def(
              "normalized"
              , normalized_function_type( &::numeric::xyzTriple<double>::normalized )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*normalized_function_type )( double const & ) const;

          xyzTriple_double_exposer.def(
              "normalized"
              , normalized_function_type( &::numeric::xyzTriple<double>::normalized )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized_any

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_any_function_type )( ::numeric::xyzTriple<double> & ) const;

          xyzTriple_double_exposer.def(
              "normalized_any"
              , normalized_any_function_type( &::numeric::xyzTriple<double>::normalized_any )
              , ( bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized_any

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_any_function_type )( double const &,::numeric::xyzTriple<double> & ) const;

          xyzTriple_double_exposer.def(
              "normalized_any"
              , normalized_any_function_type( &::numeric::xyzTriple<double>::normalized_any )
              , ( bp::arg("length_a"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized_any

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*normalized_any_function_type )(  ) const;

          xyzTriple_double_exposer.def(
              "normalized_any"
              , normalized_any_function_type( &::numeric::xyzTriple<double>::normalized_any )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized_any

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*normalized_any_function_type )( double const & ) const;

          xyzTriple_double_exposer.def(
              "normalized_any"
              , normalized_any_function_type( &::numeric::xyzTriple<double>::normalized_any )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized_or_zero

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_or_zero_function_type )( ::numeric::xyzTriple<double> & ) const;

          xyzTriple_double_exposer.def(
              "normalized_or_zero"
              , normalized_or_zero_function_type( &::numeric::xyzTriple<double>::normalized_or_zero )
              , ( bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized_or_zero

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_or_zero_function_type )( double const &,::numeric::xyzTriple<double> & ) const;

          xyzTriple_double_exposer.def(
              "normalized_or_zero"
              , normalized_or_zero_function_type( &::numeric::xyzTriple<double>::normalized_or_zero )
              , ( bp::arg("length_a"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized_or_zero

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*normalized_or_zero_function_type )(  ) const;

          xyzTriple_double_exposer.def(
              "normalized_or_zero"
              , normalized_or_zero_function_type( &::numeric::xyzTriple<double>::normalized_or_zero )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::normalized_or_zero

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*normalized_or_zero_function_type )( double const & ) const;

          xyzTriple_double_exposer.def(
              "normalized_or_zero"
              , normalized_or_zero_function_type( &::numeric::xyzTriple<double>::normalized_or_zero )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::not_equal_length

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*not_equal_length_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "not_equal_length"
              , not_equal_length_function_type( &::numeric::xyzTriple<double>::not_equal_length )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      xyzTriple_double_exposer.def( bp::self *= bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self += bp::other< double >() );
      xyzTriple_double_exposer.def( -bp::self );
      xyzTriple_double_exposer.def( bp::self -= bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self /= bp::other< double >() );
      { //::numeric::xyzTriple<double>::operator[]

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double const & ( exported_class_t::*__getitem___function_type )( int const ) const;

          xyzTriple_double_exposer.def(
              "__getitem__"
              , __getitem___function_type( &::numeric::xyzTriple<double>::operator[] )
              , ( bp::arg("i") )
              , bp::return_value_policy< bp::copy_const_reference >() );

      }
      { //::numeric::xyzTriple<double>::operator[]

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double & ( exported_class_t::*__getitem___function_type )( int const ) ;

          xyzTriple_double_exposer.def(
              "__getitem__"
              , __getitem___function_type( &::numeric::xyzTriple<double>::operator[] )
              , ( bp::arg("i") )
              , bp::return_value_policy< bp::copy_non_const_reference >() );

      }
      { //::numeric::xyzTriple<double>::project_normal

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*project_normal_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "project_normal"
              , project_normal_function_type( &::numeric::xyzTriple<double>::project_normal )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::project_parallel

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*project_parallel_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "project_parallel"
              , project_parallel_function_type( &::numeric::xyzTriple<double>::project_parallel )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::projected_normal

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*projected_normal_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "projected_normal"
              , projected_normal_function_type( &::numeric::xyzTriple<double>::projected_normal )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::projected_normal

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*projected_normal_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & ) const;

          xyzTriple_double_exposer.def(
              "projected_normal"
              , projected_normal_function_type( &::numeric::xyzTriple<double>::projected_normal )
              , ( bp::arg("v"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::projected_parallel

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> ( exported_class_t::*projected_parallel_function_type )( ::numeric::xyzTriple<double> const & ) const;

          xyzTriple_double_exposer.def(
              "projected_parallel"
              , projected_parallel_function_type( &::numeric::xyzTriple<double>::projected_parallel )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::projected_parallel

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef void ( exported_class_t::*projected_parallel_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & ) ;

          xyzTriple_double_exposer.def(
              "projected_parallel"
              , projected_parallel_function_type( &::numeric::xyzTriple<double>::projected_parallel )
              , ( bp::arg("v"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::shorter

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*shorter_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "shorter"
              , shorter_function_type( &::numeric::xyzTriple<double>::shorter )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::shorter_or_equal

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef bool ( exported_class_t::*shorter_or_equal_function_type )( ::numeric::xyzTriple<double> const & ) ;

          xyzTriple_double_exposer.def(
              "shorter_or_equal"
              , shorter_or_equal_function_type( &::numeric::xyzTriple<double>::shorter_or_equal )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::x

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double & ( exported_class_t::*x_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "x"
              , x_function_type( &::numeric::xyzTriple<double>::x )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::y

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double & ( exported_class_t::*y_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "y"
              , y_function_type( &::numeric::xyzTriple<double>::y )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::z

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef double & ( exported_class_t::*z_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "z"
              , z_function_type( &::numeric::xyzTriple<double>::z )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzTriple<double>::zero

          typedef numeric::xyzTriple<double> exported_class_t;
          typedef ::numeric::xyzTriple<double> & ( exported_class_t::*zero_function_type )(  ) ;

          xyzTriple_double_exposer.def(
              "zero"
              , zero_function_type( &::numeric::xyzTriple<double>::zero )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //property "x"[fget=::numeric::xyzTriple<double>::x, fset=::numeric::xyzTriple<double>::x]

          typedef numeric::xyzTriple<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzTriple_double_exposer.add_property(
              "x"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::x )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzTriple<double>::x )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "y"[fget=::numeric::xyzTriple<double>::y, fset=::numeric::xyzTriple<double>::y]

          typedef numeric::xyzTriple<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzTriple_double_exposer.add_property(
              "y"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::y )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzTriple<double>::y )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "z"[fget=::numeric::xyzTriple<double>::z, fset=::numeric::xyzTriple<double>::z]

          typedef numeric::xyzTriple<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzTriple_double_exposer.add_property(
              "z"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::z )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzTriple<double>::z )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "is_zero"[fget=::numeric::xyzTriple<double>::is_zero]

          typedef numeric::xyzTriple<double> fget_class_t;

          typedef bool ( fget_class_t::*fget )(  ) const;

          xyzTriple_double_exposer.add_property(
              "is_zero"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::is_zero )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "length"[fget=::numeric::xyzTriple<double>::length]

          typedef numeric::xyzTriple<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzTriple_double_exposer.add_property(
              "length"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::length )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "length_squared"[fget=::numeric::xyzTriple<double>::length_squared]

          typedef numeric::xyzTriple<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzTriple_double_exposer.add_property(
              "length_squared"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::length_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "norm"[fget=::numeric::xyzTriple<double>::norm]

          typedef numeric::xyzTriple<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzTriple_double_exposer.add_property(
              "norm"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::norm )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "norm_squared"[fget=::numeric::xyzTriple<double>::norm_squared]

          typedef numeric::xyzTriple<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzTriple_double_exposer.add_property(
              "norm_squared"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::norm_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "magnitude"[fget=::numeric::xyzTriple<double>::magnitude]

          typedef numeric::xyzTriple<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzTriple_double_exposer.add_property(
              "magnitude"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::magnitude )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "magnitude_squared"[fget=::numeric::xyzTriple<double>::magnitude_squared]

          typedef numeric::xyzTriple<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzTriple_double_exposer.add_property(
              "magnitude_squared"
              , bp::make_function(
                    fget( &::numeric::xyzTriple<double>::magnitude_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      xyzTriple_double_exposer.def( bp::other< double >() != bp::self );
      xyzTriple_double_exposer.def( bp::self != bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self != bp::self );
      xyzTriple_double_exposer.def( bp::other< double >() * bp::self );
      xyzTriple_double_exposer.def( bp::self * bp::other< double >() );
      xyzTriple_double_exposer.def( bp::other< double >() + bp::self );
      xyzTriple_double_exposer.def( bp::self + bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self + bp::self );
      xyzTriple_double_exposer.def( bp::other< double >() - bp::self );
      xyzTriple_double_exposer.def( bp::self - bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self - bp::self );
      xyzTriple_double_exposer.def( bp::self / bp::other< double >() );
      xyzTriple_double_exposer.def( bp::other< double >() < bp::self );
      xyzTriple_double_exposer.def( bp::self < bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self < bp::self );
      xyzTriple_double_exposer.def( bp::other< double >() <= bp::self );
      xyzTriple_double_exposer.def( bp::self <= bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self <= bp::self );
      xyzTriple_double_exposer.def( bp::other< double >() == bp::self );
      xyzTriple_double_exposer.def( bp::self == bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self == bp::self );
      xyzTriple_double_exposer.def( bp::other< double >() > bp::self );
      xyzTriple_double_exposer.def( bp::self > bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self > bp::self );
      xyzTriple_double_exposer.def( bp::other< double >() >= bp::self );
      xyzTriple_double_exposer.def( bp::self >= bp::other< double >() );
      xyzTriple_double_exposer.def( bp::self >= bp::self );

	  xyzTriple_double_exposer.def( bp::self_ns::str( bp::self ) );
  }

  bp::implicitly_convertible< double const &, numeric::xyzTriple<double> >();

  { //::numeric::xyzVector<double>
      typedef bp::class_< numeric::xyzVector<double> > xyzVector_double_exposer_t;
      xyzVector_double_exposer_t xyzVector_double_exposer = xyzVector_double_exposer_t( "xyzVector" ); // "numeric___xyzVector_double"
      bp::scope xyzVector_double_scope( xyzVector_double_exposer );
      xyzVector_double_exposer.def( bp::init< >() );
      xyzVector_double_exposer.def( bp::init< double const & >(( bp::arg("t") )) );
      xyzVector_double_exposer.def( bp::init< double const &, double const &, double const & >(( bp::arg("x_a"), bp::arg("y_a"), bp::arg("z_a") )) );
      { //::numeric::xyzVector<double>::assign

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*assign_function_type )( double const &,double const &,double const & ) ;

          xyzVector_double_exposer.def(
              "assign"
              , assign_function_type( &::numeric::xyzVector<double>::assign )
              , ( bp::arg("x_a"), bp::arg("y_a"), bp::arg("z_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::clear

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*clear_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "clear"
              , clear_function_type( &::numeric::xyzVector<double>::clear )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::cross

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*cross_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "cross"
              , cross_function_type( &::numeric::xyzVector<double>::cross )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::cross_product

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*cross_product_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "cross_product"
              , cross_product_function_type( &::numeric::xyzVector<double>::cross_product )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::distance

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double ( exported_class_t::*distance_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "distance"
              , distance_function_type( &::numeric::xyzVector<double>::distance )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::distance_squared

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double ( exported_class_t::*distance_squared_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "distance_squared"
              , distance_squared_function_type( &::numeric::xyzVector<double>::distance_squared )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::dot

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double ( exported_class_t::*dot_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "dot"
              , dot_function_type( &::numeric::xyzVector<double>::dot )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::dot_product

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double ( exported_class_t::*dot_product_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "dot_product"
              , dot_product_function_type( &::numeric::xyzVector<double>::dot_product )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::equal_length

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*equal_length_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "equal_length"
              , equal_length_function_type( &::numeric::xyzVector<double>::equal_length )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::inner_product

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double ( exported_class_t::*inner_product_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "inner_product"
              , inner_product_function_type( &::numeric::xyzVector<double>::inner_product )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::is_normalized

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*is_normalized_function_type )(  ) const;

          xyzVector_double_exposer.def(
              "is_normalized"
              , is_normalized_function_type( &::numeric::xyzVector<double>::is_normalized )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::is_normalized

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*is_normalized_function_type )( double const & ) const;

          xyzVector_double_exposer.def(
              "is_normalized"
              , is_normalized_function_type( &::numeric::xyzVector<double>::is_normalized )
              , ( bp::arg("tol") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::is_unit

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*is_unit_function_type )(  ) const;

          xyzVector_double_exposer.def(
              "is_unit"
              , is_unit_function_type( &::numeric::xyzVector<double>::is_unit )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::is_unit

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*is_unit_function_type )( double const & ) const;

          xyzVector_double_exposer.def(
              "is_unit"
              , is_unit_function_type( &::numeric::xyzVector<double>::is_unit )
              , ( bp::arg("tol") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::longer

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*longer_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "longer"
              , longer_function_type( &::numeric::xyzVector<double>::longer )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::longer_or_equal

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*longer_or_equal_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "longer_or_equal"
              , longer_or_equal_function_type( &::numeric::xyzVector<double>::longer_or_equal )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::max

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*max_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "max"
              , max_function_type( &::numeric::xyzVector<double>::max )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::min

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*min_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "min"
              , min_function_type( &::numeric::xyzVector<double>::min )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::negate

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*negate_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "negate"
              , negate_function_type( &::numeric::xyzVector<double>::negate )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::negated

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*negated_function_type )(  ) const;

          xyzVector_double_exposer.def(
              "negated"
              , negated_function_type( &::numeric::xyzVector<double>::negated )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::negated

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*negated_function_type )( ::numeric::xyzVector<double> & ) const;

          xyzVector_double_exposer.def(
              "negated"
              , negated_function_type( &::numeric::xyzVector<double>::negated )
              , ( bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalize

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*normalize_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "normalize"
              , normalize_function_type( &::numeric::xyzVector<double>::normalize )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalize

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*normalize_function_type )( double const & ) ;

          xyzVector_double_exposer.def(
              "normalize"
              , normalize_function_type( &::numeric::xyzVector<double>::normalize )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalize_any

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*normalize_any_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "normalize_any"
              , normalize_any_function_type( &::numeric::xyzVector<double>::normalize_any )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalize_any

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*normalize_any_function_type )( double const & ) ;

          xyzVector_double_exposer.def(
              "normalize_any"
              , normalize_any_function_type( &::numeric::xyzVector<double>::normalize_any )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalize_or_zero

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*normalize_or_zero_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "normalize_or_zero"
              , normalize_or_zero_function_type( &::numeric::xyzVector<double>::normalize_or_zero )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalize_or_zero

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*normalize_or_zero_function_type )( double const & ) ;

          xyzVector_double_exposer.def(
              "normalize_or_zero"
              , normalize_or_zero_function_type( &::numeric::xyzVector<double>::normalize_or_zero )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_function_type )( ::numeric::xyzVector<double> & ) const;

          xyzVector_double_exposer.def(
              "normalized"
              , normalized_function_type( &::numeric::xyzVector<double>::normalized )
              , ( bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_function_type )( double const &,::numeric::xyzVector<double> & ) const;

          xyzVector_double_exposer.def(
              "normalized"
              , normalized_function_type( &::numeric::xyzVector<double>::normalized )
              , ( bp::arg("length_a"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*normalized_function_type )(  ) const;

          xyzVector_double_exposer.def(
              "normalized"
              , normalized_function_type( &::numeric::xyzVector<double>::normalized )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*normalized_function_type )( double const & ) const;

          xyzVector_double_exposer.def(
              "normalized"
              , normalized_function_type( &::numeric::xyzVector<double>::normalized )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized_any

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_any_function_type )( ::numeric::xyzVector<double> & ) const;

          xyzVector_double_exposer.def(
              "normalized_any"
              , normalized_any_function_type( &::numeric::xyzVector<double>::normalized_any )
              , ( bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized_any

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_any_function_type )( double const &,::numeric::xyzVector<double> & ) const;

          xyzVector_double_exposer.def(
              "normalized_any"
              , normalized_any_function_type( &::numeric::xyzVector<double>::normalized_any )
              , ( bp::arg("length_a"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized_any

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*normalized_any_function_type )(  ) const;

          xyzVector_double_exposer.def(
              "normalized_any"
              , normalized_any_function_type( &::numeric::xyzVector<double>::normalized_any )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized_any

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*normalized_any_function_type )( double const & ) const;

          xyzVector_double_exposer.def(
              "normalized_any"
              , normalized_any_function_type( &::numeric::xyzVector<double>::normalized_any )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized_or_zero

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_or_zero_function_type )( ::numeric::xyzVector<double> & ) const;

          xyzVector_double_exposer.def(
              "normalized_or_zero"
              , normalized_or_zero_function_type( &::numeric::xyzVector<double>::normalized_or_zero )
              , ( bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized_or_zero

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*normalized_or_zero_function_type )( double const &,::numeric::xyzVector<double> & ) const;

          xyzVector_double_exposer.def(
              "normalized_or_zero"
              , normalized_or_zero_function_type( &::numeric::xyzVector<double>::normalized_or_zero )
              , ( bp::arg("length_a"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized_or_zero

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*normalized_or_zero_function_type )(  ) const;

          xyzVector_double_exposer.def(
              "normalized_or_zero"
              , normalized_or_zero_function_type( &::numeric::xyzVector<double>::normalized_or_zero )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::normalized_or_zero

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*normalized_or_zero_function_type )( double const & ) const;

          xyzVector_double_exposer.def(
              "normalized_or_zero"
              , normalized_or_zero_function_type( &::numeric::xyzVector<double>::normalized_or_zero )
              , ( bp::arg("length_a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::not_equal_length

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*not_equal_length_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "not_equal_length"
              , not_equal_length_function_type( &::numeric::xyzVector<double>::not_equal_length )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      xyzVector_double_exposer.def( bp::self *= bp::other< double >() );
      xyzVector_double_exposer.def( bp::self += bp::other< double >() );
      xyzVector_double_exposer.def( -bp::self );
      xyzVector_double_exposer.def( bp::self -= bp::other< double >() );
      xyzVector_double_exposer.def( bp::self /= bp::other< double >() );
      { //::numeric::xyzVector<double>::operator[]

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double const & ( exported_class_t::*__getitem___function_type )( int const ) const;

          xyzVector_double_exposer.def(
              "__getitem__"
              , __getitem___function_type( &::numeric::xyzVector<double>::operator[] )
              , ( bp::arg("i") )
              , bp::return_value_policy< bp::copy_const_reference >() );

      }
      { //::numeric::xyzVector<double>::operator[]

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double & ( exported_class_t::*__getitem___function_type )( int const ) ;

          xyzVector_double_exposer.def(
              "__getitem__"
              , __getitem___function_type( &::numeric::xyzVector<double>::operator[] )
              , ( bp::arg("i") )
              , bp::return_value_policy< bp::copy_non_const_reference >() );

      }
      { //::numeric::xyzVector<double>::project_normal

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*project_normal_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "project_normal"
              , project_normal_function_type( &::numeric::xyzVector<double>::project_normal )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::project_parallel

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*project_parallel_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "project_parallel"
              , project_parallel_function_type( &::numeric::xyzVector<double>::project_parallel )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::projected_normal

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*projected_normal_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "projected_normal"
              , projected_normal_function_type( &::numeric::xyzVector<double>::projected_normal )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::projected_normal

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*projected_normal_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & ) const;

          xyzVector_double_exposer.def(
              "projected_normal"
              , projected_normal_function_type( &::numeric::xyzVector<double>::projected_normal )
              , ( bp::arg("v"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::projected_parallel

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> ( exported_class_t::*projected_parallel_function_type )( ::numeric::xyzVector<double> const & ) const;

          xyzVector_double_exposer.def(
              "projected_parallel"
              , projected_parallel_function_type( &::numeric::xyzVector<double>::projected_parallel )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::projected_parallel

          typedef numeric::xyzVector<double> exported_class_t;
          typedef void ( exported_class_t::*projected_parallel_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & ) ;

          xyzVector_double_exposer.def(
              "projected_parallel"
              , projected_parallel_function_type( &::numeric::xyzVector<double>::projected_parallel )
              , ( bp::arg("v"), bp::arg("a") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::shorter

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*shorter_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "shorter"
              , shorter_function_type( &::numeric::xyzVector<double>::shorter )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::shorter_or_equal

          typedef numeric::xyzVector<double> exported_class_t;
          typedef bool ( exported_class_t::*shorter_or_equal_function_type )( ::numeric::xyzVector<double> const & ) ;

          xyzVector_double_exposer.def(
              "shorter_or_equal"
              , shorter_or_equal_function_type( &::numeric::xyzVector<double>::shorter_or_equal )
              , ( bp::arg("v") )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::x

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double & ( exported_class_t::*x_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "x"
              , x_function_type( &::numeric::xyzVector<double>::x )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::y

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double & ( exported_class_t::*y_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "y"
              , y_function_type( &::numeric::xyzVector<double>::y )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::z

          typedef numeric::xyzVector<double> exported_class_t;
          typedef double & ( exported_class_t::*z_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "z"
              , z_function_type( &::numeric::xyzVector<double>::z )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //::numeric::xyzVector<double>::zero

          typedef numeric::xyzVector<double> exported_class_t;
          typedef ::numeric::xyzVector<double> & ( exported_class_t::*zero_function_type )(  ) ;

          xyzVector_double_exposer.def(
              "zero"
              , zero_function_type( &::numeric::xyzVector<double>::zero )
              , bp::return_value_policy< bp::return_by_value >() );

      }
      { //property "x"[fget=::numeric::xyzVector<double>::x, fset=::numeric::xyzVector<double>::x]

          typedef numeric::xyzVector<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzVector_double_exposer.add_property(
              "x"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::x )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzVector<double>::x )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "y"[fget=::numeric::xyzVector<double>::y, fset=::numeric::xyzVector<double>::y]

          typedef numeric::xyzVector<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzVector_double_exposer.add_property(
              "y"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::y )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzVector<double>::y )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "z"[fget=::numeric::xyzVector<double>::z, fset=::numeric::xyzVector<double>::z]

          typedef numeric::xyzVector<double> exported_class_t;

          typedef double const & ( exported_class_t::*fget )(  ) const;
          typedef void ( exported_class_t::*fset )( double const & ) ;

          xyzVector_double_exposer.add_property(
              "z"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::z )
                  , bp::return_value_policy< bp::return_by_value >() )
              , bp::make_function(
                    fset( &::numeric::xyzVector<double>::z )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "is_zero"[fget=::numeric::xyzVector<double>::is_zero]

          typedef numeric::xyzVector<double> fget_class_t;

          typedef bool ( fget_class_t::*fget )(  ) const;

          xyzVector_double_exposer.add_property(
              "is_zero"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::is_zero )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "length"[fget=::numeric::xyzVector<double>::length]

          typedef numeric::xyzVector<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzVector_double_exposer.add_property(
              "length"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::length )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "length_squared"[fget=::numeric::xyzVector<double>::length_squared]

          typedef numeric::xyzVector<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzVector_double_exposer.add_property(
              "length_squared"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::length_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "norm"[fget=::numeric::xyzVector<double>::norm]

          typedef numeric::xyzVector<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzVector_double_exposer.add_property(
              "norm"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::norm )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "norm_squared"[fget=::numeric::xyzVector<double>::norm_squared]

          typedef numeric::xyzVector<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzVector_double_exposer.add_property(
              "norm_squared"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::norm_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "magnitude"[fget=::numeric::xyzVector<double>::magnitude]

          typedef numeric::xyzVector<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzVector_double_exposer.add_property(
              "magnitude"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::magnitude )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      { //property "magnitude_squared"[fget=::numeric::xyzVector<double>::magnitude_squared]

          typedef numeric::xyzVector<double> fget_class_t;

          typedef double ( fget_class_t::*fget )(  ) const;

          xyzVector_double_exposer.add_property(
              "magnitude_squared"
              , bp::make_function(
                    fget( &::numeric::xyzVector<double>::magnitude_squared )
                  , bp::return_value_policy< bp::return_by_value >() )  );

      }
      xyzVector_double_exposer.def( bp::other< double >() != bp::self );
      xyzVector_double_exposer.def( bp::self != bp::other< double >() );
      xyzVector_double_exposer.def( bp::self != bp::self );
      xyzVector_double_exposer.def( bp::other< double >() * bp::self );
      xyzVector_double_exposer.def( bp::self * bp::other< double >() );
      xyzVector_double_exposer.def( bp::other< double >() + bp::self );
      xyzVector_double_exposer.def( bp::self + bp::other< double >() );
      xyzVector_double_exposer.def( bp::self + bp::self );
      xyzVector_double_exposer.def( bp::other< double >() - bp::self );
      xyzVector_double_exposer.def( bp::self - bp::other< double >() );
      xyzVector_double_exposer.def( bp::self - bp::self );
      xyzVector_double_exposer.def( bp::self / bp::other< double >() );
      xyzVector_double_exposer.def( bp::other< double >() < bp::self );
      xyzVector_double_exposer.def( bp::self < bp::other< double >() );
      xyzVector_double_exposer.def( bp::self < bp::self );
      xyzVector_double_exposer.def( bp::other< double >() <= bp::self );
      xyzVector_double_exposer.def( bp::self <= bp::other< double >() );
      xyzVector_double_exposer.def( bp::self <= bp::self );
      xyzVector_double_exposer.def( bp::other< double >() == bp::self );
      xyzVector_double_exposer.def( bp::self == bp::other< double >() );
      xyzVector_double_exposer.def( bp::self == bp::self );
      xyzVector_double_exposer.def( bp::other< double >() > bp::self );
      xyzVector_double_exposer.def( bp::self > bp::other< double >() );
      xyzVector_double_exposer.def( bp::self > bp::self );
      xyzVector_double_exposer.def( bp::other< double >() >= bp::self );
      xyzVector_double_exposer.def( bp::self >= bp::other< double >() );
      xyzVector_double_exposer.def( bp::self >= bp::self );

	  xyzVector_double_exposer.def( bp::self_ns::str( bp::self ) );
  }

  bp::implicitly_convertible< double const &, numeric::xyzVector<double> >();

  { //::numeric::add

      typedef void ( *add_function_type )( double const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "add" //"numeric___add"
          , add_function_type( &::numeric::add )
          , ( bp::arg("t"), bp::arg("v"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::add

      typedef void ( *add_function_type )( ::numeric::xyzTriple<double> const &,double const &,::numeric::xyzTriple<double> & );

      bp::def(
          "add"
          , add_function_type( &::numeric::add )
          , ( bp::arg("v"), bp::arg("t"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::add

      typedef void ( *add_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "add" //"numeric___add"
          , add_function_type( &::numeric::add )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::add

      typedef void ( *add_function_type )( double const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "add" //"numeric___add"
          , add_function_type( &::numeric::add )
          , ( bp::arg("t"), bp::arg("v"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::add

      typedef void ( *add_function_type )( ::numeric::xyzVector<double> const &,double const &,::numeric::xyzVector<double> & );

      bp::def(
          "add" //"numeric___add"
          , add_function_type( &::numeric::add )
          , ( bp::arg("v"), bp::arg("t"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::add

      typedef void ( *add_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "add" //"numeric___add"
          , add_function_type( &::numeric::add )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::angle_of

      typedef double ( *angle_of_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "angle_of" //"numeric___angle_of"
          , angle_of_function_type( &::numeric::angle_of )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::angle_of

      typedef double ( *angle_of_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "angle_of" //"numeric___angle_of"
          , angle_of_function_type( &::numeric::angle_of )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::angle_of

      typedef double ( *angle_of_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "angle_of" //"numeric___angle_of"
          , angle_of_function_type( &::numeric::angle_of )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::angle_of

      typedef double ( *angle_of_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "angle_of" // "numeric___angle_of"
          , angle_of_function_type( &::numeric::angle_of )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef void ( *center_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("d"), bp::arg("m") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef ::numeric::xyzTriple<double> ( *center_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "center" // "numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("d") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef void ( *center_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("m") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef ::numeric::xyzTriple<double> ( *center_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef void ( *center_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("m") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef ::numeric::xyzTriple<double> ( *center_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef void ( *center_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("d"), bp::arg("m") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef ::numeric::xyzVector<double> ( *center_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("d") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef void ( *center_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("m") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef ::numeric::xyzVector<double> ( *center_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef void ( *center_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("m") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::center

      typedef ::numeric::xyzVector<double> ( *center_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "center" //"numeric___center"
          , center_function_type( &::numeric::center )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cos_of

      typedef double ( *cos_of_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "cos_of" //"numeric___cos_of"
          , cos_of_function_type( &::numeric::cos_of )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cos_of

      typedef double ( *cos_of_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "cos_of" //"numeric___cos_of"
          , cos_of_function_type( &::numeric::cos_of )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cos_of

      typedef double ( *cos_of_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "cos_of"
          , cos_of_function_type( &::numeric::cos_of )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cos_of

      typedef double ( *cos_of_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "cos_of"
          , cos_of_function_type( &::numeric::cos_of )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cross

      typedef void ( *cross_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "cross"
          , cross_function_type( &::numeric::cross )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cross

      typedef ::numeric::xyzTriple<double> ( *cross_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "cross"
          , cross_function_type( &::numeric::cross )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cross

      typedef void ( *cross_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "cross"
          , cross_function_type( &::numeric::cross )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cross

      typedef ::numeric::xyzVector<double> ( *cross_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "cross"
          , cross_function_type( &::numeric::cross )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cross_product

      typedef void ( *cross_product_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "cross_product"
          , cross_product_function_type( &::numeric::cross_product )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cross_product

      typedef ::numeric::xyzTriple<double> ( *cross_product_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "cross_product"
          , cross_product_function_type( &::numeric::cross_product )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cross_product

      typedef void ( *cross_product_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "cross_product"
          , cross_product_function_type( &::numeric::cross_product )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::cross_product

      typedef ::numeric::xyzVector<double> ( *cross_product_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "cross_product"
          , cross_product_function_type( &::numeric::cross_product )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::distance

      typedef double ( *distance_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "distance"
          , distance_function_type( &::numeric::distance )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::distance

      typedef double ( *distance_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "distance"
          , distance_function_type( &::numeric::distance )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::distance_squared

      typedef double ( *distance_squared_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "distance_squared"
          , distance_squared_function_type( &::numeric::distance_squared )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::distance_squared

      typedef double ( *distance_squared_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "distance_squared"
          , distance_squared_function_type( &::numeric::distance_squared )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::divide

      typedef void ( *divide_function_type )( ::numeric::xyzTriple<double> const &,double const &,::numeric::xyzTriple<double> & );

      bp::def(
          "divide"
          , divide_function_type( &::numeric::divide )
          , ( bp::arg("v"), bp::arg("t"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::divide

      typedef void ( *divide_function_type )( ::numeric::xyzVector<double> const &,double const &,::numeric::xyzVector<double> & );

      bp::def(
          "divide"
          , divide_function_type( &::numeric::divide )
          , ( bp::arg("v"), bp::arg("t"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::dot

      typedef double ( *dot_function_type )( ::numeric::Quaternion<double> const &,::numeric::Quaternion<double> const & );

      bp::def(
          "dot"
          , dot_function_type( &::numeric::dot )
          , ( bp::arg("q1"), bp::arg("q2") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::dot

      typedef double ( *dot_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "dot"
          , dot_function_type( &::numeric::dot )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::dot

      typedef double ( *dot_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "dot"
          , dot_function_type( &::numeric::dot )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::dot_product

      typedef double ( *dot_product_function_type )( ::numeric::Quaternion<double> const &,::numeric::Quaternion<double> const & );

      bp::def(
          "dot_product"
          , dot_product_function_type( &::numeric::dot_product )
          , ( bp::arg("q1"), bp::arg("q2") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::dot_product

      typedef double ( *dot_product_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "dot_product"
          , dot_product_function_type( &::numeric::dot_product )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::dot_product

      typedef double ( *dot_product_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "dot_product"
          , dot_product_function_type( &::numeric::dot_product )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::eigenvalue_jacobi

      typedef ::numeric::xyzVector<double> ( *eigenvalue_jacobi_function_type )( ::numeric::xyzMatrix<double> const &,double const & );

      bp::def(
          "eigenvalue_jacobi"
          , eigenvalue_jacobi_function_type( &::numeric::eigenvalue_jacobi )
          , ( bp::arg("a"), bp::arg("tol") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::eigenvector_jacobi

      typedef ::numeric::xyzVector<double> ( *eigenvector_jacobi_function_type )( ::numeric::xyzMatrix<double> const &,double const &,::numeric::xyzMatrix<double> & );

      bp::def(
          "eigenvector_jacobi"
          , eigenvector_jacobi_function_type( &::numeric::eigenvector_jacobi )
          , ( bp::arg("a"), bp::arg("tol"), bp::arg("J") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::equal_length

      typedef bool ( *equal_length_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "equal_length"
          , equal_length_function_type( &::numeric::equal_length )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::equal_length

      typedef bool ( *equal_length_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "equal_length"
          , equal_length_function_type( &::numeric::equal_length )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::inner_product

      typedef double ( *inner_product_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "inner_product"
          , inner_product_function_type( &::numeric::inner_product )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::inner_product

      typedef double ( *inner_product_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "inner_product"
          , inner_product_function_type( &::numeric::inner_product )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::inplace_product

      typedef ::numeric::xyzVector<double> & ( *inplace_product_function_type )( ::numeric::xyzMatrix<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "inplace_product"
          , inplace_product_function_type( &::numeric::inplace_product )
          , ( bp::arg("m"), bp::arg("v") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::inplace_transpose_product

      typedef ::numeric::xyzVector<double> & ( *inplace_transpose_product_function_type )( ::numeric::xyzMatrix<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "inplace_transpose_product"
          , inplace_transpose_product_function_type( &::numeric::inplace_transpose_product )
          , ( bp::arg("m"), bp::arg("v") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::jacobi_rotation

      typedef void ( *jacobi_rotation_function_type )( ::numeric::xyzMatrix<double> const &,int const,int const,::numeric::xyzMatrix<double> & );

      bp::def(
          "jacobi_rotation"
          , jacobi_rotation_function_type( &::numeric::jacobi_rotation )
          , ( bp::arg("m"), bp::arg("i"), bp::arg("j"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef long double ( *max_function_type )( long double const,long double const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef double ( *max_function_type )( double const,double const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef float ( *max_function_type )( float const,float const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef long unsigned int ( *max_function_type )( long unsigned int const,long unsigned int const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef unsigned int ( *max_function_type )( unsigned int const,unsigned int const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef short unsigned int ( *max_function_type )( short unsigned int const,short unsigned int const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef long int ( *max_function_type )( long int const,long int const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef int ( *max_function_type )( int const,int const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef short int ( *max_function_type )( short int const,short int const );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef ::numeric::xyzTriple<double> ( *max_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::max

      typedef ::numeric::xyzVector<double> ( *max_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "max"
          , max_function_type( &::numeric::max )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::midpoint

      typedef void ( *midpoint_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "midpoint"
          , midpoint_function_type( &::numeric::midpoint )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("m") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::midpoint

      typedef ::numeric::xyzTriple<double> ( *midpoint_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "midpoint"
          , midpoint_function_type( &::numeric::midpoint )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::midpoint

      typedef void ( *midpoint_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "midpoint"
          , midpoint_function_type( &::numeric::midpoint )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("m") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::midpoint

      typedef ::numeric::xyzVector<double> ( *midpoint_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "midpoint"
          , midpoint_function_type( &::numeric::midpoint )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef long double ( *min_function_type )( long double const,long double const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef double ( *min_function_type )( double const,double const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef float ( *min_function_type )( float const,float const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef long unsigned int ( *min_function_type )( long unsigned int const,long unsigned int const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef unsigned int ( *min_function_type )( unsigned int const,unsigned int const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef short unsigned int ( *min_function_type )( short unsigned int const,short unsigned int const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef long int ( *min_function_type )( long int const,long int const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef int ( *min_function_type )( int const,int const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef short int ( *min_function_type )( short int const,short int const );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef ::numeric::xyzTriple<double> ( *min_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::min

      typedef ::numeric::xyzVector<double> ( *min_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "min"
          , min_function_type( &::numeric::min )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::multiply

      typedef void ( *multiply_function_type )( double const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "multiply"
          , multiply_function_type( &::numeric::multiply )
          , ( bp::arg("t"), bp::arg("v"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::multiply

      typedef void ( *multiply_function_type )( ::numeric::xyzTriple<double> const &,double const &,::numeric::xyzTriple<double> & );

      bp::def(
          "multiply"
          , multiply_function_type( &::numeric::multiply )
          , ( bp::arg("v"), bp::arg("t"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::multiply

      typedef void ( *multiply_function_type )( double const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "multiply"
          , multiply_function_type( &::numeric::multiply )
          , ( bp::arg("t"), bp::arg("v"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::multiply

      typedef void ( *multiply_function_type )( ::numeric::xyzVector<double> const &,double const &,::numeric::xyzVector<double> & );

      bp::def(
          "multiply"
          , multiply_function_type( &::numeric::multiply )
          , ( bp::arg("v"), bp::arg("t"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::not_equal_length

      typedef bool ( *not_equal_length_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "not_equal_length"
          , not_equal_length_function_type( &::numeric::not_equal_length )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::not_equal_length

      typedef bool ( *not_equal_length_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "not_equal_length"
          , not_equal_length_function_type( &::numeric::not_equal_length )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::outer_product

      typedef ::numeric::xyzMatrix<double> ( *outer_product_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "outer_product"
          , outer_product_function_type( &::numeric::outer_product )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  // { //::numeric::product
  //
  //     typedef ::numeric::Quaternion<double> ( *product_function_type )( ::numeric::Quaternion<double> const &,::numeric::Quaternion<double> const &,bool const );
  //
  //     bp::def(
  //         "numeric___product"
  //         , product_function_type( &::numeric::product )
  //         , ( bp::arg("q2"), bp::arg("q1"), bp::arg("precise")=(bool const)(true) )
  //         , bp::return_value_policy< bp::return_by_value >() );
  //
  // }

  { //::numeric::product

      typedef ::numeric::xyzVector<double> ( *product_function_type )( ::numeric::xyzMatrix<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "product"
          , product_function_type( &::numeric::product )
          , ( bp::arg("m"), bp::arg("v") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::projection_matrix

      typedef ::numeric::xyzMatrix<double> ( *projection_matrix_function_type )( ::numeric::xyzVector<double> const & );

      bp::def(
          "projection_matrix"
          , projection_matrix_function_type( &::numeric::projection_matrix )
          , ( bp::arg("v") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::rotation_axis

      typedef ::numeric::xyzVector<double> ( *rotation_axis_function_type )( ::numeric::xyzMatrix<double> const &,double & );

      bp::def(
          "rotation_axis"
          , rotation_axis_function_type( &::numeric::rotation_axis )
          , ( bp::arg("R"), bp::arg("theta") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::rotation_matrix

      typedef ::numeric::xyzMatrix<double> ( *rotation_matrix_function_type )( ::numeric::xyzVector<double> const &,double const & );

      bp::def(
          "rotation_matrix"
          , rotation_matrix_function_type( &::numeric::rotation_matrix )
          , ( bp::arg("axis"), bp::arg("theta") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::sin_of

      typedef double ( *sin_of_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "sin_of"
          , sin_of_function_type( &::numeric::sin_of )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::sin_of

      typedef double ( *sin_of_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const & );

      bp::def(
          "sin_of"
          , sin_of_function_type( &::numeric::sin_of )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::sin_of

      typedef double ( *sin_of_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "sin_of"
          , sin_of_function_type( &::numeric::sin_of )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::sin_of

      typedef double ( *sin_of_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "sin_of"
          , sin_of_function_type( &::numeric::sin_of )
          , ( bp::arg("a"), bp::arg("b") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::subtract

      typedef void ( *subtract_function_type )( double const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "subtract"
          , subtract_function_type( &::numeric::subtract )
          , ( bp::arg("t"), bp::arg("v"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::subtract

      typedef void ( *subtract_function_type )( ::numeric::xyzTriple<double> const &,double const &,::numeric::xyzTriple<double> & );

      bp::def(
          "subtract"
          , subtract_function_type( &::numeric::subtract )
          , ( bp::arg("v"), bp::arg("t"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::subtract

      typedef void ( *subtract_function_type )( ::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> const &,::numeric::xyzTriple<double> & );

      bp::def(
          "subtract"
          , subtract_function_type( &::numeric::subtract )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::subtract

      typedef void ( *subtract_function_type )( double const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "subtract"
          , subtract_function_type( &::numeric::subtract )
          , ( bp::arg("t"), bp::arg("v"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::subtract

      typedef void ( *subtract_function_type )( ::numeric::xyzVector<double> const &,double const &,::numeric::xyzVector<double> & );

      bp::def(
          "subtract"
          , subtract_function_type( &::numeric::subtract )
          , ( bp::arg("v"), bp::arg("t"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::subtract

      typedef void ( *subtract_function_type )( ::numeric::xyzVector<double> const &,::numeric::xyzVector<double> const &,::numeric::xyzVector<double> & );

      bp::def(
          "subtract"
          , subtract_function_type( &::numeric::subtract )
          , ( bp::arg("a"), bp::arg("b"), bp::arg("r") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

  { //::numeric::transpose_product

      typedef ::numeric::xyzVector<double> ( *transpose_product_function_type )( ::numeric::xyzMatrix<double> const &,::numeric::xyzVector<double> const & );

      bp::def(
          "transpose_product"
          , transpose_product_function_type( &::numeric::transpose_product )
          , ( bp::arg("m"), bp::arg("v") )
          , bp::return_value_policy< bp::return_by_value >() );

  }

}
