// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

#include "boost/python.hpp"
// #include "boost/python/suite/indexing/indexing_suite.hpp"
// #include "boost/python/suite/indexing/vector_indexing_suite.hpp"
// #include "boost/python/suite/indexing/map_indexing_suite.hpp"

#include "utility/vector1.hh"
#include "utility/pointer/access_ptr.hh"

#include "core/chemical/AtomType.hh"
#include "core/chemical/AtomTypeSet.hh"
#include "core/chemical/MMAtomType.hh"
#include "core/chemical/MMAtomTypeSet.hh"
#include "core/chemical/ResidueType.hh"
#include "core/chemical/ResidueTypeSet.hh"

#include "core/conformation/Atom.hh"

#include "core/coarse/Translator.hh"
#include "core/coarse/CoarseEtable.hh"

#include <core/pack/task/PackerTask.hh>


#include "utility/exit.hh"

#include <ostream>


namespace bp = boost::python;
using namespace std;
using namespace utility;

template< class T >
T * getCAP( pointer::access_ptr<T> rs ) {
  T & rs_ref( *rs );
  T * rs_ptr = &rs_ref;
  return rs_ptr;
}

/*
template <class T>
std::ostream& operator <<(std::ostream &os, utility::vector1<T> const & v)
{
	os << "[";
	for(unsigned int i=1; i<=v.size(); i++) {
		os << v[i] << ", ";
	}
	os << "]";
	return os;
} */

template <class T>
std::string vector1_repr(utility::vector1<T> const & v)
{
	std::ostringstream os;

	os << "~~~[";
	for(unsigned int i=1; i<=v.size(); i++) {
		os << v[i] << ", ";
	}
	os << "]";
	return os.str();
}

template< class TT > inline void vector1_set( vector1<TT> & v, size_t const & i, TT const & val ) { v[i] = val; }
template< class TT > inline std::size_t vector1_len( vector1<TT> & v ) { return v.size(); }

template< class TT > inline std::string vector1_str( vector1<TT> & v ) { std::ostringstream s; s<<v; return s.str(); }

template< class TT > inline typename vector1<TT>::iterator vector1_begin( vector1<TT> & v ) { return v.begin(); }
template< class TT > inline typename vector1<TT>::iterator vector1_end  ( vector1<TT> & v ) { return v.end(); }
template< class Htype, class CP, class CP_const>
void wrap_vector1(char * name) {
  typedef vector1<Htype> Ttype;
  typedef vectorL<1,Htype,allocator<Htype> > Btype;
  typedef vector<Htype> Vtype;
  bp::class_<Ttype>(name)
    .def( bp::init< size_t >() )
    .def( bp::init< vector1<Htype> const & >() )
    // .def( bp::init< size_t, TT >() )
    .def("__getitem__"
        , (Htype const & (Ttype::*)(size_t const) const)( &Ttype::at )
        , CP_const()    )
    .def("__getitem__"
        , (Htype & (Ttype::*)(size_t const))( &Ttype::at )
        , CP()        )
    .def("__setitem__"
        , &vector1_set<Htype> )
    .def("append"
        , (Btype & (Btype::*)(Htype const &))( &Btype::add_back )
        , bp::return_value_policy< bp::reference_existing_object >()        )
    .def("__len__", & vector1_len<Htype> )
    .def("__iter__", bp::range(&vector1_begin<Htype>,&vector1_end<Htype>) )

    //.def("__str__", & vector1_str<Htype> )
    .def("__str__", & vector1_repr<Htype> )
	//.def( bp::self_ns::str( bp::self ) )
  ;
}

template< class Htype, class CP, class CP_const>
void wrap_vector1_part(char * name) {
  typedef vector1<Htype> Ttype;
  typedef vectorL<1,Htype,allocator<Htype> > Btype;
  typedef vector<Htype> Vtype;
  bp::class_<Ttype>(name)
    .def("__getitem__"
        , (Htype const & (Ttype::*)(size_t const) const)( &Ttype::at )
        , CP_const()    )
    .def("__getitem__"
        , (Htype & (Ttype::*)(size_t const))( &Ttype::at )
        , CP()        )
    .def("__setitem__"
        , &vector1_set<Htype> )
    .def("append"
        , (Btype & (Btype::*)(Htype const &))( &Btype::add_back )
        , bp::return_value_policy< bp::reference_existing_object >()        )
    .def("__len__", & vector1_len<Htype> )
    .def("__iter__", bp::range(&vector1_begin<Htype>,&vector1_end<Htype>) )
  ;
}


template< class Type >
void wrap_owning_pointer(char * name)
{
	bp::class_<Type>(name)
		//.def("get", &Type::get)
		.def("reset_to_null", &Type::reset_to_null)
	;
}



// .def("__iter__", bp::range( &core::pose::Pose::res_begin, &core::pose::Pose::res_end));

inline bool vector1_bool_get ( vector1<bool> & v, int i ) { if(v[i]) return true; else return false; }
inline void vector1_bool_push( vector1<bool> & v, bool h ) { return v.push_back(h); }

void pyexit_callback(void)
{
	throw "RosettaException";
}

void set_pyexit_callback(void)
{
	set_exit_callback(pyexit_callback);
}

void wrap__utility__by_hand(){

	bp::def("set_pyexit_callback", set_pyexit_callback);
	bp::def("pyexit_callback", pyexit_callback);

	//wrap_owning_pointer<core::pack::task::PackerTaskOP>("PackerTaskOP");


  using namespace pointer;
  typedef bp::return_value_policy< bp::reference_existing_object > CP_REF;
  typedef bp::return_value_policy< bp::copy_const_reference >      CP_CCR;
  typedef bp::return_value_policy< bp::copy_non_const_reference >  CP_CNCR;

  wrap_vector1<vector1<size_t>,CP_REF,CP_REF>("vec1_vec1_Size");

  wrap_vector1<string,       CP_CNCR, CP_CCR>("vector1_string");
  wrap_vector1<int,          CP_CNCR, CP_CCR>("vector1_int");
  wrap_vector1<long,         CP_CNCR, CP_CCR>("vector1_long");
  wrap_vector1<unsigned long,CP_CNCR, CP_CCR>("vector1_ulong");
  wrap_vector1<char,         CP_CNCR, CP_CCR>("vector1___char");
  wrap_vector1<float,        CP_CNCR, CP_CCR>("vector1_float");
  wrap_vector1<double,       CP_CNCR, CP_CCR>("vector1_double");
  wrap_vector1<unsigned,     CP_CNCR, CP_CCR>("vector1_unsisned");


  //if( true ) { // This code never executed, but we need it so compilere create operator ostream << vector1[core::conformation::Atom]
  //	cout << vector1< core::conformation::Atom > () ;
  //}
  //wrap_vector1_part<core::conformation::Atom, CP_REF, CP_REF>("vector1_core_conformation_Atom");
  wrap_vector1_part<core::conformation::Atom, CP_CNCR, CP_CCR>("vector1_core_conformation_Atom");

  // wrap_vector1<bool,         CP_CNCR,CP_CCR>("utility___vector1_bool");
  bp::class_< vector1<bool> >("vector1_bool")
    .def("__len__",&vector1_len<bool> )
    .def("append", &vector1_bool_push )
    .def("__getitem__", &vector1_bool_get )
    .def("__iter__",bp::range(&vector1_begin<bool>,&vector1_end<bool>))
  ;

  // bp::class_< vector1<vector1<size_t> > >("utility___vec1_vec1_size")
  //   .def(bp::vector_indexing_suite< vector1<vector1<size_t> > >() );

  bp::class_< access_ptr< core::chemical::AtomTypeSet const   > >("core___chemical___AtomTypeSetCAP");
  bp::class_< access_ptr< core::chemical::ResidueType const   > >("core___chemical___ResidueTypeCAP");
  bp::class_< access_ptr< core::chemical::ResidueTypeSet const> >("core___chemical___ResidueTypeSetCAP");
  bp::class_< access_ptr< core::chemical::MMAtomTypeSet const > >("core___chemical___MMAtomTypeSetCAP");
  bp::class_< access_ptr< core::coarse::Translator const      > >("core___coarse___TranslatorCAP");
  bp::class_< access_ptr< core::coarse::CoarseEtable const    > >("core___coarse___CoarseEtableCAP");

  using namespace core::chemical;
  using namespace core::coarse;

  bp::def("utility___getCAP"
         , (  ResidueTypeSet const * (*)( access_ptr<ResidueTypeSet const> )  )( & getCAP<ResidueTypeSet const> )
         , bp::return_value_policy< bp::reference_existing_object >() );
  bp::def("utility___getCAP"
         , (  AtomTypeSet const * (*)( access_ptr<AtomTypeSet const> )  )( & getCAP<AtomTypeSet const> )
         , bp::return_value_policy< bp::reference_existing_object >() );
  bp::def("utility___getCAP"
         , (  ResidueType const * (*)( access_ptr<ResidueType const> )  )( & getCAP<ResidueType const> )
         , bp::return_value_policy< bp::reference_existing_object >() );
  bp::def("utility___getCAP"
         , (  MMAtomTypeSet const * (*)( access_ptr<MMAtomTypeSet const> )  )( & getCAP<MMAtomTypeSet const> )
         , bp::return_value_policy< bp::reference_existing_object >() );
  bp::def("utility___getCAP"
         , (  Translator const * (*)( access_ptr<Translator const> )  )( & getCAP<Translator const> )
         , bp::return_value_policy< bp::reference_existing_object >() );
  bp::def("utility___getCAP"
         , (  CoarseEtable const * (*)( access_ptr<CoarseEtable const> )  )( & getCAP<CoarseEtable const> )
         , bp::return_value_policy< bp::reference_existing_object >() );


}
