# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
import pymol_io
import rosetta_io

class MolComplex:
    def __init__(self, name, native_name):

        self.name = name

        if not native_name:
            self.native_name = name
        else:
            self.native_name = native_name

        #TODO mo move to res_table?
        self.resfilename = None
        self.score_filename = None

        self.derivitive_counter = 0
        self.native_score = None
        self.score = None

        #mo initialize residues and selections
        self.res_ids = pymol_io.residues( self )
        self.res_ids.sort()

        self.rosetta_res_ids =  None

        #mo initialize scoring terms
        self.obj_level_score_terms = {}
        self.residue_level_score_terms = {}

        self.view = "compact"
        self.display_defaults = False

        self.num_res_types = {}
        self.packable = {}
        pymol_io.default_display(self)


    def get_num_res_types( self, res_id ):
        return self.num_res_types.get(res_id, None)

    def set_num_res_types(self, num_res_types):
        self.num_res_types = num_res_types

    def get_not_packable( self ):
        not_packable = []
        for res_id in self.res_ids:
            not_packable.append(not self.packable.get(res_id, False))
        return not_packable

    def set_packable(self, packable):
        self.packable = []
        for pack_residue in packable:
            self.packable.append( pack_residue )

    def get_residue_colors(self):
        return pymol_io.get_residue_colors(self)


    def get_view( self ):
        if self.view == 'compact':
            return self.compact_view()
        elif self.view == 'complete':
            return self.complete_view()
        else:
            print "no such view!", self.view

##    def test_tasks( self ):
##        text1 = """
##
##NATAA  #keep the sequence fixed for all residues that do not have residue-specific behavior given.
##EX 1 EX 2 #use extra rotamers
##
###next the start token signals the start of residue-level commands
##start
##5 A NATRO #the formatting is: first the resid, then commands
##1 A ALLAAwc #note that resid order is arbitrary
##8 A ALLAAxc
##7 A PIKAA ACDEF #this is the proper formatting for PIKAA
##22 A PIKAA QWERYIPLHGDSACNM #note that the string need not be in alpha order
##4 A NOTAA QRSTVWYI #same formatting for NOTAA
##23 A NOTAA NVCLHTREWQ #also out of order
##11 A POLAR
##15 A APOLAR EX 1 #a mode command and an EX command.  Note that this residue will NOT have EX 2 applied
##17 A EX 1 EX 3 NATRO #EX commands can come before the mode commands, also note EX 2 not applied
##2 A PIKAA E EX 4 LEVEL 3 EX 3 EX ARO 1 EX ARO 2 LEVEL 4 #5 commands here
##30 A NATAA EX 1 EX 2 #recapitulating the default explicitly is legal
##        """
##
##        self.parse_resfile( text1 )
##
##        result_text1 = self.compact_view()
##
##        if text1 != result_text1:
##            print "original resfile:"
##            print text1
##            print "returned resfile:"
##            print result_text1
