# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


# In the installation of Rosetta Design Wizard a launcher is put in a directory that pymol can find.
# This script attempts to delete this file and otherwise give hints about how to find it and delete it by hand.

import os
import util

settings_data = util.read_settingsfile()
if 'launcher_directory' in settings_data:
    try:
        os.remove( settings_data[ 'launcher_directory' + os.sep + 'rdwizard_launcher.py'  ] )
        os.remove( settings_data[ 'launcher_directory' + os.sep + 'rdwizard_launcher.pyc' ] )
    except:
        print "unable to remove rdwizard_launcher.py, perhapse you don't have sufficient access rights?"
else:
    print "Either the launch script was never installed, it has already been removed.\n\n"
    print "if you feel that that it still lurks, you can try to delete rdwizard_launcher.py by hand."
    print "1) find modules/pmg_tk/rdwizard_launcher.py near where the PYMOL_PATH"
    print "In some installations of pymol running 'which pymol | xargs cat' can give you a clue of where to look"
    print "2) detete both rdwizard_launcher.py and rdwizard_launcher.pyc"
    print "good luck!"




