// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   test/comparative_modeling/util.cxxtest.hh
/// @brief  test suite for comparative modeling utilities in
/// protocols/comparative_modeling/util.cc.
/// @author James Thompson

// Test headers
#include <cxxtest/TestSuite.h>

#include <test/core/init_util.hh>

#include <core/util/Tracer.hh>
#include <core/sequence/Sequence.hh>
#include <core/sequence/NWAligner.hh>
#include <core/sequence/ScoringScheme.hh>
#include <core/sequence/SimpleScoringScheme.hh>
#include <core/sequence/ScoringSchemeFactory.hh>
#include <core/sequence/SequenceAlignment.hh>

#include <protocols/comparative_modeling/AlignmentStream.hh>
#include <protocols/comparative_modeling/DynamicAlignmentStream.hh>

static core::util::Tracer TR("test.protocols.comparative_modeling");

class AlignmentStream_Tests : public CxxTest::TestSuite {

public:
AlignmentStream_Tests() {}

void setUp() {
	core_init();
}

void tearDown() {}

void test_aln_stream() {
	using namespace core::sequence;
	using namespace protocols::comparative_modeling;

	SequenceOP seq1( new Sequence( "ABACDEF", "one", '-' ) );
	SequenceOP seq2( new Sequence( "DDABCDEF", "two", '-' ) );
	AlignerOP aligner( new NWAligner );
	ScoringSchemeFactory ssf;
	ScoringSchemeOP ss( new SimpleScoringScheme( 10, 1, -1, -1 ) );
	SequenceAlignment align = aligner->align( seq1, seq2, ss );

	// verify that we know what the alignment looks like
	TS_ASSERT( align.sequence(1)->sequence() == "ABACDEF" );
	TS_ASSERT( align.sequence(2)->sequence() == "AB-CDEF" );

	// make sure that we get the same alignment back from
	// the DynamicAlignmentStream.
	DynamicAlignmentStream alignments( seq1, seq2, ss, aligner );
	SequenceAlignment dyn_align = alignments.get_alignment();
	TS_ASSERT( dyn_align.sequence(1)->sequence() == "ABACDEF" );
	TS_ASSERT( dyn_align.sequence(2)->sequence() == "AB-CDEF" );
}

}; // class AlignmentStream_Tests
