// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/moves/TaskAwareMinMover.cxxtest.hh
/// @brief  test for TaskAwareMinMover
/// @author Steven Lewis

// Test headers
#include <cxxtest/TestSuite.h>
#include <test/core/init_util.hh>

// Utilities
#include <core/types.hh>

#include <core/io/pdb/pose_io.hh>
#include <core/pose/Pose.hh>

#include <core/kinematics/MoveMap.hh>

#include <protocols/moves/MinMover.hh>
#include <protocols/moves/TaskAwareMinMover.hh>

#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/pack/task/TaskFactory.hh>
#include <core/pack/task/operation/TaskOperations.hh>

// --------------- Test Class --------------- //

class TaskAwareMinMoverTests : public CxxTest::TestSuite {

	core::pose::Pose pose;

public:

	// --------------- Fixtures --------------- //

	void setUp() {
		core_init();
		core::io::pdb::pose_from_pdb( pose, "protocols/moves/test_in_short.pdb" );
	}

	void tearDown() {
		pose.clear();
	}

	// ------------- Helper Functions ------------- //


	// --------------- Test Cases --------------- //

	///@brief make a TAMinMover, run it, check underlying movemap of underlying minmover to ensure correct freedoms
	void test_TaskAwareMinMover() {

		//////////////////////TaskFactory
		using namespace core::pack::task;
		TaskFactoryOP task_factory = new TaskFactory();
		operation::ReadResfileOP rrop = new operation::ReadResfile;
		rrop->filename("protocols/moves/TaskAwareMinMover.resfile");
		task_factory->push_back( rrop );

		///////////////////////starting MoveMap
		core::kinematics::MoveMapOP mm(new core::kinematics::MoveMap() );
		mm->set_bb(false); mm->set_jump(false); mm->set_chi(false); //ensure no freedoms

		/////////////////////////minimizer mover/////////////////////////////////////////
		using namespace core::scoring;
		using protocols::moves::MinMoverOP;
		using protocols::moves::MinMover;
		MinMoverOP min_mover = new MinMover(
																				mm,
																				//ScoreFunctionFactory::create_score_function( STANDARD_WTS, SCORE12_PATCH ),
																				core::scoring::ScoreFunctionOP(new core::scoring::ScoreFunction() ),
																				//a null scorefunction is fine; we don't actually need to minimize anything
																				"dfpmin_armijo", //faster and irrelevant for the purpose...
																				0.01,
																				true /*use_nblist*/ );

		////////////////////////TAminmover///////////////////////////////////////////////
		using protocols::moves::TaskAwareMinMoverOP;
		using protocols::moves::TaskAwareMinMover;
		TaskAwareMinMoverOP TAmin_mover = new TaskAwareMinMover(min_mover, task_factory);

		/////////////////////////run
		TAmin_mover->apply(pose);

		//////////////////now query minmover about its movemap
		using namespace core::id;
		core::kinematics::MoveMapCOP mm_mod(min_mover->movemap());
		for(core::Size i(1); i <= pose.total_residue(); ++i){
			TS_ASSERT(!mm_mod->get(TorsionID(i, BB, psi_torsion)));
			TS_ASSERT(!mm_mod->get(TorsionID(i, BB, phi_torsion)));
			TS_ASSERT(!mm_mod->get(TorsionID(i, BB, omega_torsion)));
			if(i <= 3 && i >= 1){
				TS_ASSERT(mm_mod->get(TorsionID(i, CHI, 1)));
			} else {
				TS_ASSERT(!mm_mod->get(TorsionID(i, CHI, 1)));
			}
		}
	}//end test_TaskAwareMinMover

};//end class
