#!/usr/bin/env python
# :noTabs=true:
# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

# --> relax <-- scientific test


import os


T_condor_job_header = '''
universe     = vanilla
Notify_user  =
notification = Error
Log          = .condorscript.log
Executable   = %(bin)s/relax.%(binext)s

Requirements = ( Memory > 256)
GetEnv       = True

'''


T_condor_job_target = '''
## now looprelax jobs
Error   = output/%(target)s/logerr
Output  = output/%(target)s/logout
arguments = -database %(database)s -run:protocol relax -relax:cycle_ratio 1.0 \
            -l input/centroid_abinitio/%(target)s/list -out:file:silent output/%(target)s/%(target)s.out \
            -in:file:fullatom -native input/fragments/%(target)s/boinc_rb1_%(target)s.pdb \
            -random_delay 5 -silent_decoytime -mute all -seed_offset $(Process)
queue 1

'''

targets = ['1a19', '1acf', '1b3a', '1bkr', '1c8c', '1cei', '1dhn', '1enh', '1fkb', '1hz6',
           '1kpe', '1nps', '1ptq', '1scj', '1tif', '1tul', '1urn', '1vie', '1wit', '2chf',
           '4ubp', '1a32', '1ail', '1bgf', '1bm8', '1c9o', '1cg5', '1e6i', '1ew4', '1fna',
           '1ig5', '1lis', '1opd', '1r69', '1shf', '1tig', '1ubi', '1utg', '1vls', '256b',
           '2ci2', '5cro', '1a68', '1aiu', '1bk2', '1bq9', '1cc8', '1ctf', '1elw', '1eyv',
           '1gvp', '1iib', '1lou', '1pgx', '1rnb', '1ten', '1tit', '1ugh', '1vcc', '1who',
           '2acy', '2vik'
           ]


print 'Running submit.py script for cluster loop scientific test...'


m_vars = eval( file('_arguments.py').read() )

condor = T_condor_job_header % m_vars

for t in targets:
    os.mkdir('output/'+t)
    m_vars['target'] = t
    condor += T_condor_job_target % m_vars

f = file('condor', 'w');  f.write(condor);  f.close()
