// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @ docking_protocol.cc
/// @ author James Thompson, Jeff Gray


// Rosetta headers
#include <protocols/docking/DockingProtocol.hh>
#include <protocols/jd2/JobDistributor.hh>
#include <protocols/init.hh>
#include <core/types.hh>

// Utility headers
#include <utility/vector1.hh>
#include <utility/tools/make_vector1.hh>

// option key includes
#include <core/options/keys/docking.OptionKeys.gen.hh>
#include <core/options/option.hh>

int
main( int argc, char * argv [] )
{
	using namespace core::options;
	using namespace protocols::docking;
	using namespace protocols::jd2;

	// initialize core
	protocols::init(argc, argv);

	DockingProtocolOP dp = new DockingProtocol();

	if ( option[ OptionKeys::docking::multibody ].user() ) {
			utility::vector1< core::Size > const movable_jumps(
				option[ OptionKeys::docking::multibody ]()
			);
			dp->set_movable_jumps( movable_jumps );
	}

	JobDistributor::get_instance()->go(dp);
}

