// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/core/chemical/AtomTypeSet.fwd.hh
/// @author Ian W. Davis


#ifndef INCLUDED_core_chemical_CSDAtomTypeSet_FWD_HH
#define INCLUDED_core_chemical_CSDAtomTypeSet_FWD_HH

#include <utility/pointer/access_ptr.fwd.hh>
#include <utility/pointer/owning_ptr.fwd.hh>

namespace core {
namespace chemical {

class CSDAtomTypeSet;

typedef  utility::pointer::access_ptr< CSDAtomTypeSet > CSDAtomTypeSetAP;
typedef  utility::pointer::access_ptr< CSDAtomTypeSet const > CSDAtomTypeSetCAP;
typedef  utility::pointer::owning_ptr< CSDAtomTypeSet > CSDAtomTypeSetOP;
typedef  utility::pointer::owning_ptr< CSDAtomTypeSet const > CSDAtomTypeSetCOP;

}
}

#endif
