// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


/// @brief  some utilities for fragments
/// @author Oliver Lange (olange@u.washington.edu)
/// @date   Wed Oct 20 12:08:31 2007
///


#ifndef core_fragment_FragmentIO_HH
#define core_fragment_FragmentIO_HH

// Unit Headers

// Package Headers
// AUTO-REMOVED #include <core/fragment/ConstantLengthFragSet.hh>

// Project Headers
#include <core/types.hh>
// AUTO-REMOVED #include <core/pose/Pose.fwd.hh>

//#include <core/FragmentIO/CacheableData.hh>

// ObjexxFCL Headers

// utility headers
#include <utility/vector1.fwd.hh>
// AUTO-REMOVED #include <utility/fix_boinc_read.hh>

//Auto Headers
#include <core/fragment/FragSet.fwd.hh>
#include <core/fragment/Frame.fwd.hh>
#include <core/fragment/FrameList.fwd.hh>
#include <core/fragment/SingleResidueFragData.fwd.hh>
#include <iostream>
#include <map>


namespace core {
namespace fragment {


class FragFactory {
public:
	FragFactory(void);

	void add_frag_type( std::string const& type_name, SingleResidueFragDataOP frag_type );
	void add_frame_type( std::string const& type_name, FrameOP new_frag );

	FrameOP frame( std::string const& frame_name ) const;
	SingleResidueFragDataOP frag_type( std::string const& frag_name ) const;

private:
	typedef std::map< std::string, SingleResidueFragDataOP > SRFD_Types;
	SRFD_Types frag_types_;

	typedef std::map< std::string, FrameOP > FrameTypes;
	FrameTypes frame_types_;

}; // class FragFactory



class FragmentIO {
public:
	FragmentIO() : top25_( 0 ), ncopies_( 1 ), bAnnotate_( true ) {};
	FragmentIO( Size top25, Size ncopies = 1, bool bAnnotate = true ) :
		top25_( top25 ),
		ncopies_( ncopies ),
		bAnnotate_( bAnnotate )
	{};

	///@brief read a FragSet... note that this function is cacheing the fragment set
	/// i.e., if you read the same set from multiple positions in the code you get the same set.
	/// if you read a new file ... we'll check the cache for stale references and delete them...
	FragSetOP read_data( std::string const & filename );

	void read_data( std::string const& filename, FrameList& );

	void read_data( std::istream& data, FrameList& );

	void write_data( std::string const& file, FragSet const& frags );

	FragFactory& get_frag_factory();

	// options for reading
	void set_top_frag_num( Size setting ) {
		top25_ = setting;
	}

	void set_ncopies( Size setting ) {
		ncopies_ = setting;
	}

	void set_read_annotation( bool setting = true ) {
		bAnnotate_ = setting;
	}

	///@brief remove all FragSets that are not referenced outside the cache.
	void clean_frag_cache();

private:
	void read_next_frames( std::istream& data, std::string& next_line, FrameList &next_frames );
	void read_frag_data(  std::istream& data, std::string& next_line, FrameList &next_frames );
	static FragFactory frag_factory_;

	typedef std::map< std::string, FragSetOP > FragFileCache;
	static FragFileCache frag_cache_;
	Size top25_;
	Size ncopies_;
	bool bAnnotate_; //reads annotated fragments...
}; // FragmentIO

} // fragment
} // core


#endif
