// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/CompositeFragmentSelector.hh
/// @brief provides a selector that picks best fragments based on their total score
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_CompositeFragmentSelector_HH
#define INCLUDED_core_fragment_picking_CompositeFragmentSelector_HH

//#include <core/fragment/picking/CompositeFragmentSelector.fwd.hh>
#include <core/fragment/picking/FragmentSelectingRule.hh>

// package headers
#include <core/fragment/picking/FragmentCandidate.fwd.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

#include <utility/vector1.hh>
//#include <vector>


namespace core {
namespace fragment {
namespace picking {

/// @brief selects fragments by running several selectors
class CompositeFragmentSelector: public FragmentSelectingRule {
public:

	/// @brief  Constructor sets the desired number of fragments.
	CompositeFragmentSelector(Size frags_per_pos) : FragmentSelectingRule(frags_per_pos) {
	}

	/// @brief  Selects desired number of fragments from a given set of candidates
	virtual void select_fragments(utility::vector1<std::pair<
			FragmentCandidateOP, scores::FragmentScoreMapOP> >& ,
			utility::vector1<std::pair<FragmentCandidateOP,
					scores::FragmentScoreMapOP> >& );

	virtual ~CompositeFragmentSelector() {
	}

	void add_selector(FragmentSelectingRuleOP new_selector) { selectors_.push_back( new_selector ); }
private:
	utility::vector1<FragmentSelectingRuleOP> selectors_;
};

} // picking
} // fragment
} // core


#endif /* INCLUDED_core_fragment_picking_CompositeFragmentSelector_HH */
