// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/quota/QuotaSelector.hh
/// @brief provides a selector that picks best fragments based on their total score
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_quota_QuotaSelector_HH
#define INCLUDED_core_fragment_picking_quota_QuotaSelector_HH

#include <core/fragment/picking/quota/QuotaSelector.fwd.hh>
#include <core/fragment/picking/quota/QuotaCollector.hh>
#include <core/fragment/picking/quota/QuotaPool.hh>

#include <core/fragment/picking/FragmentSelectingRule.hh>

// package headers
#include <core/fragment/picking/CommonFragmentComparators.hh>
#include <core/fragment/picking/FragmentCandidate.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

// utility headers
#include <core/types.hh>

// C++ headers
#include <set>

namespace core {
namespace fragment {
namespace picking {
namespace quota {

/// @brief selects a given number of fragments using a quota scheme
class QuotaSelector: public FragmentSelectingRule {
public:

	/// @brief  Constructor sets the desired number of fragments.
	QuotaSelector(Size,Size,QuotaCollectorOP);

	virtual ~QuotaSelector() {
	}

	/// @brief  Selects desired number of fragments from a given candidates
	virtual void select_fragments(utility::vector1<std::pair<
			FragmentCandidateOP, scores::FragmentScoreMapOP> >& in,
			utility::vector1<std::pair<FragmentCandidateOP,
					scores::FragmentScoreMapOP> >& out)  {
		select_fragments_25_200(in,out);
	}
protected:
	QuotaCollectorOP collector_;
	Size q_pos_;
	inline Size round(Real x) { return Size(x > 0.0 ? x + 0.5 : x - 0.5); }

	Size next_from_pool(utility::vector1<std::pair<FragmentCandidateOP,
                scores::FragmentScoreMapOP> > &,Size ,std::set<Size> &);
	void push_the_limits(utility::vector1<Size> & q_limits,Size target_total);

	void push_the_limits_to_the_winner(utility::vector1<Size> & q_limits,Size target_total);

	void push_the_limits(utility::vector1<Size> &,Size,utility::vector1<Real> &);

	virtual void select_fragments_200(utility::vector1<std::pair<
			FragmentCandidateOP, scores::FragmentScoreMapOP> >&,
			utility::vector1<std::pair<FragmentCandidateOP,
					scores::FragmentScoreMapOP> >&) ;
	virtual void select_fragments_25_200(utility::vector1<std::pair<
			FragmentCandidateOP, scores::FragmentScoreMapOP> >&,
			utility::vector1<std::pair<FragmentCandidateOP,
					scores::FragmentScoreMapOP> >&) ;
private:
    utility::vector1<std::string> tags_;
    std::map<std::string,Size> tag_map_;
};

} // quota
} // picking
} // fragment
} // core


#endif /* INCLUDED_core_fragment_picking_quota_QuotaSelector_HH */
