// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/scores/FragmentScoringMethod.hh
/// @brief  FragmentScoringMethod forward declaration
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_scores_FragmentScoringMethod_FWD_HH
#define INCLUDED_core_fragment_picking_scores_FragmentScoringMethod_FWD_HH

// utility headers
#include <utility/pointer/access_ptr.hh>
#include <utility/pointer/owning_ptr.hh>

namespace core {
namespace fragment {
namespace picking {
namespace scores {

/// @brief forward declaration for FragmentScoringMethod
class FragmentScoringMethod;

typedef utility::pointer::owning_ptr<FragmentScoringMethod>
		FragmentScoringMethodOP;
typedef utility::pointer::owning_ptr<FragmentScoringMethod const>
		FragmentScoringMethodCOP;

class MakeFragmentScoringMethod;

typedef utility::pointer::owning_ptr<MakeFragmentScoringMethod>
		MakeFragmentScoringMethodOP;
typedef utility::pointer::owning_ptr<MakeFragmentScoringMethod const>
		MakeFragmentScoringMethodCOP;

} // scores
} // picking
} // fragment
} // core


#endif /* INCLUDED_core_fragment_picking_scores_FragmentScoringMethod_FWD_HH */
