// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/FragmentCrmsd.hh
/// @brief  Object that scores a fragment by its crmsd to the native
/// @author Nikolas Sgourakis sgourn@u.w.edu

#ifndef INCLUDED_core_fragment_picking_JCoupling_HH
#define INCLUDED_core_fragment_picking_JCoupling_HH

// package headers
#include <core/fragment/picking/FragmentCandidate.fwd.hh>
#include <core/fragment/picking/scores/CachingScoringMethod.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

// mini
#include <core/types.hh>

#include <ObjexxFCL/FArray1D.hh>

//Auto Headers
#include <core/fragment/picking/JCouplingIO.hh>
#include <core/pose/Pose.fwd.hh>
#include <iostream>


namespace core {
namespace fragment {
namespace picking {
namespace scores {


/// @brief  scores a fragment by the JCouplings
class JCoupling: public CachingScoringMethod {
public:

	/// @brief  creates a
	/// @detailed
	JCoupling(Size, Real, bool, JCouplingIO&);

	void do_caching(VallChunkOP);
	void clean_up();
	bool cached_score(FragmentCandidateOP, FragmentScoreMapOP);
	bool score(FragmentCandidateOP, FragmentScoreMapOP);

private:
	//std::string cached_scores_id_; // cache is not yet built
	JCouplingIO data_;
	Size len_;
	Real A_, B_, C_, THETA_;
};

/// @brief  Matker class that produces a new JCoupling object
class MakeJCoupling: public MakeFragmentScoringMethod {
public:

	MakeJCoupling() :
		MakeFragmentScoringMethod("JCoupling") {
	}

	FragmentScoringMethodOP make(Size, Real, bool, FragmentPickerOP, std::string);
};

}
}
}
}

#endif // INCLUDED_core_fragment_picking_JCoupling_HH
