// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/scores/fragment_scoring_utilities.hh
/// @brief  functions and data types common for fragment scoring
/// @author Dominik Gront

#ifndef INCLUDED_core_fragment_picking_scores_fragment_scoring_utilities_HH
#define INCLUDED_core_fragment_picking_scores_fragment_scoring_utilities_HH

// type headers
#include <core/types.hh>
#include <utility/vector1.hh>

#include <algorithm>

namespace core {
namespace fragment {
namespace picking {
namespace scores {

typedef utility::vector1< utility::vector1 < Real > > Matrix;


void do_one_line(Size start_i,Size start_j,Matrix & small_scores,Size frag_len,Matrix & frag_scores);
void rolling_score(Matrix & small_scores,Size frag_len,Matrix & frag_scores);
void create_cache(utility::vector1<Size> & frag_sizes,Size query_len,Size longest_vall_chunk,utility::vector1<Matrix> & cache);
void allocate_matrix(Size i_size,Size j_size,Matrix & dst);


} // scores
} // picking
} // fragment
} // core

#endif /* INCLUDED_core_fragment_picking_scores_fragment_scoring_utilities_HH */
