// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/graph/PointGraphData.hh
/// @brief  classes to work with UpperEdgeGraph for fast neighbor detection
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)


#ifndef INCLUDED_core_graph_PointGraphData_HH
#define INCLUDED_core_graph_PointGraphData_HH

// Project Headers
#include <platform/types.hh>

// Numeric Headers
#include <numeric/xyzVector.hh>

namespace core {
namespace graph {

class PointGraphVertexData
{
public:
	PointGraphVertexData() : xyz_( 0.0, 0.0, 0.0 ) {}
	PointGraphVertexData( numeric::xyzVector< platform::Real > const & coors ) : xyz_( coors ) {}

	numeric::xyzVector< platform::Real > & xyz() { return xyz_; }
	numeric::xyzVector< platform::Real > const & xyz() const { return xyz_; }

	static int const NUM_EDGES_TO_RESERVE = 50;

private:
	numeric::xyzVector< platform::Real > xyz_;

};

class PointGraphEdgeData
{
public:
	PointGraphEdgeData() : dsq_( 0.0 ) {}

	///@brief inputs and outputs are distances squared
	PointGraphEdgeData( platform::Real d2 ) : dsq_( d2 ) {}

	platform::Real & dsq() { return dsq_; }
	platform::Real dsq() const { return dsq_; }

private:
	platform::Real dsq_;
};

}
}

#endif
