// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/grid/Pockets/PocketGrid.fwd.hh
/// @brief  core::grid::Pockets::PocketGrid forward declarations header
/// @author David Johnson
/// @author Ragul Gowthaman


#ifndef INCLUDED_core_grid_Pockets_PocketGrid_FWD_HH
#define INCLUDED_core_grid_Pockets_PocketGrid_FWD_HH


// Utility headers
#include <utility/pointer/owning_ptr.fwd.hh>


namespace core {
namespace grid {
namespace Pockets {

// Forward
class PCluster;
class PClusterSet;
class PocketGrid;

// Types
typedef utility::pointer::owning_ptr< PocketGrid >  PocketGridOP;
typedef utility::pointer::owning_ptr< PocketGrid const >  PocketGridCOP;


} // namespace pockets
} // namespace grid
} // namespace core

#endif
