// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


/// @file core/scoring/hbonds/HBondDatabase.fwd.hh
/// @brief forward header for HBondDatabase class
/// @author Matthew O'Meara (mattjomeara@gmail.com)

#ifndef INCLUDED_core_scoring_hbonds_HBondDatabase_FWD_HH
#define INCLUDED_core_scoring_hbonds_HBondDatabase_FWD_HH

#include <utility/pointer/owning_ptr.hh>

namespace core{
namespace scoring{
namespace hbonds{

class HBondDatabase;

typedef utility::pointer::owning_ptr< HBondDatabase > HBondDatabaseOP;
typedef utility::pointer::owning_ptr< HBondDatabase const > HBondDatabaseCOP;

} //hbonds
} //scoring
} //core

#endif // INCLUDED_core_scoring_hbonds_HBondDatabase_FWD_HH
