// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

#ifndef ORBITALSSCORE_HH_
#define ORBITALSSCORE_HH_

#include <core/scoring/methods/ContextDependentTwoBodyEnergy.hh>
#include <core/pose/Pose.fwd.hh>
#include <numeric/xyzVector.hh>
#include <core/scoring/orbitals/OrbitalsLookup.hh>
#include <core/scoring/orbitals/OrbitalsScore.fwd.hh>
#include <core/scoring/etable/EtableEnergy.hh>
#include <core/scoring/methods/EnergyMethodOptions.hh>

namespace core{
namespace scoring{
namespace orbitals{

class OrbitalsScore : public methods::ContextDependentTwoBodyEnergy {

public:
	typedef methods::ContextDependentTwoBodyEnergy parent;

public:
	OrbitalsScore(methods::EnergyMethodOptions const & options);

	//clone
	virtual methods::EnergyMethodOP clone() const;

	virtual void setup_for_scoring(pose::Pose &, ScoreFunction const &) const;


	virtual void setup_for_derivatives( pose::Pose &pose, ScoreFunction const &  ) const;



	virtual void eval_intrares_energy(
			const core::conformation::Residue&,
			const core::pose::Pose&, const core::scoring::ScoreFunction&,
			core::scoring::EnergyMap&
			) const;

	 virtual bool defines_intrares_energy(const core::scoring::EnergyMap&) const;


	 virtual void residue_pair_energy(
			 const core::conformation::Residue & res1,
			 const core::conformation::Residue & res2,
			 const core::pose::Pose &,
			 const core::scoring::ScoreFunction &,
			 EnergyMap & emap
			 ) const;

	 virtual core::Distance atomic_interaction_cutoff() const;

	 void get_E_hpol_haro(
				core::conformation::Residue const & res1,
				core::conformation::Residue const & res2,
				core::Real & hapol_E,
				core::Real & haro_E
		) const;


	 ///@brief check the distance of the action center of two residues. Important for improving speed.
	 bool check_act_dist(core::conformation::Residue const & res1, core::conformation::Residue const & res2) const;

	//virtual Distance atomic_interaction_cutoff() const;

	virtual void indicate_required_context_graphs( utility::vector1< bool > &  ) const;

/*	virtual void
	eval_residue_pair_derivatives(
		conformation::Residue const & rsd1,
		conformation::Residue const & rsd2,
		ResSingleMinimizationData const &,
		ResSingleMinimizationData const &,
		ResPairMinimizationData const &,
		pose::Pose const &, // provides context
		EnergyMap const & weights,
		utility::vector1< DerivVectorPair > & r1_atom_derivs,
		utility::vector1< DerivVectorPair > & r2_atom_derivs
	) const;*/


	void
	res_res_hpol_haro_derivs_one_way(
		conformation::Residue const & don_rsd,
		conformation::Residue const & acc_rsd,
		EnergyMap const & weights,
		utility::vector1< DerivVectorPair > & don_atom_derivs,
		utility::vector1< DerivVectorPair > & acc_atom_derivs
	) const;


	void get_atom_atom_E_hpol_haro(
			core::conformation::Residue const & res1,
			core::conformation::Residue const & res2,
			core::Size const orbital,
			core::Real & hpol_E,
			core::Real & haro_E
			) const;

	void get_orb_orb_E(core::conformation::Residue const & res1,
			core::conformation::Residue const & res2,
			core::Real & orb_orb_E) const;



private:
		OrbitalsLookup const & lookup_table_;
		core::scoring::etable::EtableEnergy lookup_Etable_;
		core::Real const max_dist_squared_; //the maximum distance squared which orbitals are scored
		//core::scoring::etable::EtableCAP etable_;

};





}//namespace orbitals
}//namespace scoring
}//namespace core



#endif /* ORBITALSSCORE_HH_ */
