// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/saxs/PDDFEnergy.hh
/// @brief  "Energy" based on a similarity of theoretical PDDF (pairwise distance distribution function)
/// @author Dominik Gront (dgront@chem.uw.edu.pl)


#ifndef INCLUDED_core_scoring_saxs_PDDFEnergy_HH
#define INCLUDED_core_scoring_saxs_PDDFEnergy_HH

// Package headers
#include <core/scoring/saxs/PDDFEnergy.fwd.hh>
#include <core/scoring/saxs/FormFactorManager.hh>
#include <core/scoring/saxs/FormFactor.hh>
#include <core/scoring/saxs/PDDFEnergyCreator.hh>

#include <core/scoring/EnergyMap.hh>
#include <core/scoring/methods/WholeStructureEnergy.hh>
#include <core/scoring/methods/EnergyMethodOptions.hh>

#include <core/scoring/ScoreType.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

// Project headers
#include <core/pose/Pose.fwd.hh>

namespace core {
namespace scoring {
namespace saxs {


class PDDFEnergy : public methods::WholeStructureEnergy  {
public:

    PDDFEnergy();

    PDDFEnergy(utility::vector1<Real> const &,utility::vector1<Real> const &);

    virtual ~PDDFEnergy() {}

    virtual methods::EnergyMethodOP clone() const { return new PDDFEnergy(); }

    virtual void finalize_total_energy(pose::Pose & pose,ScoreFunction const &,EnergyMap & totals) const;

    virtual void indicate_required_context_graphs(utility::vector1< bool > & /*context_graphs_required*/
    ) const {}

    methods::EnergyMethodOP create_energy_method(methods::EnergyMethodOptions const &) const {
	return new PDDFEnergy();
    }

    utility::vector1<Real>&  get_pddf() {
	return pose_pddf_;
    }

    utility::vector1<Real>&  get_dist_bins() {
	return d_;
    }

    utility::vector1<Real> & compute_pddf(const core::pose::Pose &) const;
    utility::vector1<Real> & compute_pddf_without_ff(const core::pose::Pose &) const;
    Real compute_chi(utility::vector1<Real> const &, utility::vector1<Real> const &) const;
    Real compute_L1(utility::vector1<Real> const &, utility::vector1<Real> const &) const;
    void create_pddf(core::pose::Pose &,Real,Real,Real);

    Real evaluate_pddf_energy(const pose::Pose & pose) const;

private:
    mutable utility::vector1< utility::vector1<Real> > factors_;
    mutable utility::vector1<Size> r_ids_;
    mutable utility::vector1<Size> a_ids_;
    mutable utility::vector1< utility::vector1<core::Real> > dmatrix_;
    mutable utility::vector1<bool> is_glob_;

    Real norm_;
    bool if_fit_area_;
    utility::vector1<Real> d_;
    mutable utility::vector1<Real> pose_pddf_;
    utility::vector1<Real> reference_pddf_;
    FormFactorManager* ff_manager_;
    Real bin_size_;
    Size min_bin_;
    Size max_bin_;
    bool if_hydrogens_;

    void read_pddf(std::string);
};


}
}
}

#endif
