// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

#ifndef INCLUDED_core_util_basic_HH
#define INCLUDED_core_util_basic_HH

#include <core/types.hh>


// util_basic Function Declarations

namespace core {
namespace util {

void
calc_quadratic(
	Real a,
	Real b,
	Real c,
	Real & n1,
	Real & n2
);


Real
subtract_degree_angles(
	Real a,
	Real b
);


Real
subtract_radian_angles(
	Real a,
	Real b
);


Real
periodic_range(
	Real a,
	Real x
);

/// @brief a is restricted to [0.,x), assuming that a=a+n*x,, n=any integer
Real
unsigned_periodic_range(
	Real a,
	Real x
);


/// taken from wobble.cc
void
angle_in_range( Real & ang );


}
}

#endif
