// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file FragmentSampler.cc
/// @brief ab-initio fragment assembly protocol for proteins
/// @detailed
///	  Contains currently: Classic Abinitio
///
///
/// @author Oliver Lange

// Unit Headers
#include <protocols/NoesyAssign/CyanaModule.hh>

// Package Headers
#include <protocols/NoesyAssign/PeakAssignmentParameters.hh>
#include <protocols/NoesyAssign/ResonanceList.hh>
#include <protocols/NoesyAssign/PeakFileFormat.hh>
#include <protocols/NoesyAssign/DistanceScoreMover.hh>

// Project Headers
#include <core/scoring/constraints/ConstraintSet.hh>
#include <core/io/silent/SilentFileData.hh>
#include <core/pose/Pose.hh>
#include <core/scoring/constraints/AmbiguousNMRConstraint.hh>

// for switching residue type set to centroid
#include <core/chemical/util.hh>
#include <core/chemical/ChemicalManager.fwd.hh>

// Utility headers
#include <core/util/Tracer.hh>

//// C++ headers
#include <math.h> //for isnan

static core::util::Tracer tr("devel.NoesyAssign.crosspeaks");

using core::Real;
using namespace core;
using namespace util;
//using namespace core::options;
//using namespace OptionKeys;

namespace protocols {
namespace NoesyAssign {
