// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file NoesyModule.hh
/// @author Oliver Lange

#ifndef INCLUDED_protocols_NoesyAssign_NoesyModule_HH
#define INCLUDED_protocols_NoesyAssign_NoesyModule_HH


// Unit Header
#include <protocols/NoesyAssign/NoesyModule.fwd.hh>

// Package Headers
#include <protocols/NoesyAssign/CrossPeak.hh>
#include <protocols/NoesyAssign/PeakFileFormat.fwd.hh>
#include <protocols/NoesyAssign/PeakAssignmentResidueMap.hh>
#include <protocols/NoesyAssign/PeakAssignmentParameters.hh>
//#include <protocols/NoesyAssign/ResonanceList.fwd.hh>

// Project Headers
#include <core/types.hh>

// Utility headers
#include <utility/exit.hh>
#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>

//// C++ headers
// #include <cstdlib>
// #include <string>
// #include <list>
// #include <map>

namespace protocols {
namespace NoesyAssign {

class NoesyModule : public utility::pointer::ReferenceCount {

private:
 static bool options_registered_;

public:
  static void register_options();

public:
  NoesyModule( std::string const& fasta_sequence );

  //if no cycle selected it will be read from commandline
  template< class DecoyIterator >
  void assign( DecoyIterator const& begin, DecoyIterator const& end, core::Size cycle = 0 );

  /// decoy file will be determined from commandline and read directly
  void assign ( core::Size cycle = 0 );

  void generate_constraint_files( core::pose::Pose const& pose, std::string const& cst_fa_file, std::string const& cst_centroid_file, core::Size min_seq_separation ) const;

  void write_assignments( std::string file = "use_cmd_line" );

  ///@brief reset assignments...
  void reset();

  ///@brief returns true if -noesy::in::resonances and -noesy::in::peaks are in cmd-line
  static bool cmdline_options_activated();

  CrossPeakList const& crosspeaks() const { return *crosspeaks_; }
  ResonanceList const& resonances() const { return *resonances_; }

private:
  void read_input_files();

  bool skip_network_analysis_;

  CrossPeakListOP crosspeaks_;
  ResonanceListOP resonances_;
};

}
}

#endif
