// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file PeakAssignmentParametersList.hh
/// @author Oliver Lange

#ifndef INCLUDED_protocols_NoesyAssign_PeakAssignmentParameters_HH
#define INCLUDED_protocols_NoesyAssign_PeakAssignmentParameters_HH


// Unit Header
//#include <protocols/NoesyAssign/PeakAssignmentParameters.fwd.hh>

// Package Headers
// #include <protocols/NoesyAssign/PeakAssignmentParametersInfo.hh>
// #include <protocols/NoesyAssign/PeakAssignment.hh>
// #include <protocols/NoesyAssign/ResonanceList.fwd.hh>

// Project Headers
#include <core/types.hh>
#include <core/id/NamedAtomID.fwd.hh>
//#include <core/chemical/AA.hh>

// Utility headers
//#include <utility/exit.hh>
// #include <utility/excn/Exceptions.hh>
//#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>
// #include <numeric/numeric.functions.hh>
// #include <core/util/prof.hh>
//#include <core/util/Tracer.hh>
// #include <core/options/option.hh>
// #include <core/options/keys/abinitio.OptionKeys.gen.hh>
// #include <core/options/keys/run.OptionKeys.gen.hh>
//#include <core/options/keys/templates.OptionKeys.gen.hh>

//// C++ headers
//#include <cstdlib>
// #include <string>
// #include <list>
// #include <map>

namespace protocols {
namespace NoesyAssign {

class PeakAssignmentParameters { //: public utility::pointer::ReferenceCount {

private:
  static bool options_registered_;

public:
  static void register_options();
  void set_options_from_cmdline();
  static void set_cycle( core::Size );
  static PeakAssignmentParameters* get_instance();
private:
  static PeakAssignmentParameters* instance_;
  static core::Size cycle_selector_;

public:
  /* maybe make all options const
     make cmd-line options vectors for 7 cycles and have static function that
     switches cycles by throwing away one instance and creating a new one with the given
     cycle number and setting all const-params in the constructor from the cmd-line.

     all good, unless I want to change the things from somewhere else than cmdline...
  */

  //cycle independent
  core::Real chemshift_overlap_weight_; //Gamma, eq. (4)
  core::Real dmax_; //unused
  core::Real vmin_;
  core::Real vmax_;
  core::Real nmax_;
  core::Real nr_conformers_violatable_; //Mvio in fraction of nr_conformers
  core::Real network_reswise_high_;
  core::Real centroid_mapping_distance_padding_;
  //cycle dependent
  core::Real symmetry_compliance_weight_; //T, eq. (5)
  core::Real covalent_compliance_weight_; //O
  core::Real decoy_compatibility_exponent_; //eta, eq. (6)

  core::Real smax_;
  core::Real dcut_;
  core::Real network_reswise_min_; //N_bar_min
  core::Real network_atom_min_; //N_min per atom
  core::Real calibration_target_;

  core::Real min_volume_; //minimum volume contribution

  core::Real cst_strength_; //for  1/cst_strength ->sigma for BoundFunc

  bool network_include_reverse_dir_;
  bool network_allow_same_residue_connect_;
};

}
}

#endif
