// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/AddSidechainConstraintsToHotspots.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_AddSidechainConstraintsToHotspots_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_AddSidechainConstraintsToHotspots_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class AddSidechainConstraintsToHotspots : public protocols::moves::Mover
{
public:
	AddSidechainConstraintsToHotspots();
	void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;
	void parse_my_tag( utility::Tag::TagPtr const tag,
		protocols::moves::DataMap &,
		protocols::filters::Filters_map const &,
		protocols::moves::Movers_map const &,
		core::pose::Pose const & );
	protocols::moves::MoverOP clone() const { return( protocols::moves::MoverOP( new AddSidechainConstraintsToHotspots( *this ) ) ); }
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new AddSidechainConstraintsToHotspots ); }
	virtual ~AddSidechainConstraintsToHotspots();
	core::Size chain() const;
	void chain( core::Size const c );
	core::Real coord_sdev() const;
	void coord_sdev( core::Real const sdev );
private:
	core::Size chain_; //dflt 2
	core::Real coord_sdev_; //dflt 1.0
};


} //movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_AddSidechainConstraintsToHotspots_HH*/

