// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/comparative_modeling/AlignmentStream.hh
/// @brief
/// @author James Thompson

#ifndef protocols_comparative_modeling_AlignmentStream_HH
#define protocols_comparative_modeling_AlignmentStream_HH

#include <core/sequence/Sequence.hh>
#include <core/sequence/SequenceAlignment.hh>


namespace protocols {
namespace comparative_modeling {

class AlignmentStream {

public:
	AlignmentStream () {}
	virtual ~AlignmentStream() {}

	/// @brief Gets the next alignment from the stream. Might be the same
	/// alignment every time, or might be a different alignment after each
	/// call to this function.
	virtual core::sequence::SequenceAlignment get_alignment() = 0;

}; // AlignmentStream

} // comparative_modeling
} // protocols

#endif
