// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/comparative_modeling/DynamicAlignmentStream.hh
/// @brief Alignment stream that dynamically generates an alignment
/// given two Sequence objects, a ScoringScheme and an Aligner object.
/// @author James Thompson

#ifndef protocols_comparative_modeling_DynamicAlignmentStream_HH
#define protocols_comparative_modeling_DynamicAlignmentStream_HH


#include <core/sequence/Aligner.hh>
#include <core/sequence/Aligner.fwd.hh>
#include <core/sequence/ScoringScheme.hh>

#include <core/sequence/Sequence.hh>
#include <core/sequence/Sequence.fwd.hh>

// AUTO-REMOVED #include <core/sequence/SequenceAlignment.hh>


namespace protocols {
namespace comparative_modeling {

class DynamicAlignmentStream {

public:
	DynamicAlignmentStream (
		core::sequence::SequenceOP seq1,
		core::sequence::SequenceOP seq2,
		core::sequence::ScoringSchemeOP ss,
		core::sequence::AlignerOP aligner
	) :
		seq_x_( seq1 ),
		seq_y_( seq2 ),
		ss_   ( ss ),
		aligner_( aligner )
	{}
	virtual ~DynamicAlignmentStream() {}

	/// @brief Gets the next alignment from the stream by aligning two
	/// sequences using the given Aligner object and the given
	/// ScoringScheme. This will call the Aligner.align function for
	/// each call to get_alignment, so be aware that results are not
	/// guaranteed to always be constant.

	virtual core::sequence::SequenceAlignment get_alignment();

private:
	core::sequence::SequenceOP seq_x_;
	core::sequence::SequenceOP seq_y_;
	core::sequence::ScoringSchemeOP ss_;

	core::sequence::AlignerOP aligner_;
}; // DynamicAlignmentStream

} // comparative_modeling
} // protocols

#endif
