// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/comparative_modeling/StaticAlignmentStream.hh
/// @brief Alignment stream that just returns an alignment.
/// @author James Thompson

#ifndef protocols_comparative_modeling_StaticAlignmentStream_HH
#define protocols_comparative_modeling_StaticAlignmentStream_HH


#include <core/sequence/Aligner.hh>
#include <core/sequence/Aligner.fwd.hh>
#include <core/sequence/ScoringScheme.hh>

#include <core/sequence/Sequence.hh>
#include <core/sequence/Sequence.fwd.hh>
#include <core/sequence/SequenceAlignment.hh>


namespace protocols {
namespace comparative_modeling {

class StaticAlignmentStream {

public:
	StaticAlignmentStream (
		core::sequence::SequenceAlignment align
	) : alignment_( align )
	{}
	virtual ~StaticAlignmentStream() {}

	/// @brief Returns the SequenceAlignment contained in this object.
	virtual core::sequence::SequenceAlignment get_alignment();

private:
	core::sequence::SequenceAlignment alignment_;
}; // StaticAlignmentStream

} // comparative_modeling
} // protocols

#endif
