/// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/domain_assembly/AddAssemblyConstraints.fwd.hh
/// @brief  Adds constraints for the assembling process
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_protocols_domain_assembly_AddAssemblyConstraints_HH
#define INCLUDED_protocols_domain_assembly_AddAssemblyConstraints_HH


#include <protocols/domain_assembly/AddAssemblyConstraints.fwd.hh>

#include <protocols/moves/Mover.hh>
#include <core/pose/Pose.hh>
#include <core/types.hh>
#include <string>

namespace protocols {
namespace domain_assembly {

class AddAssemblyConstraints : public protocols::moves::Mover {
public:

	AddAssemblyConstraints() : Mover("AddAssemblyConstraints") {}

	virtual std::string get_name() const {
		return "AddAssemblyConstraints";
	}

	void apply( core::pose::Pose & pose );
};


}//namespace domain_assembly
}//namespace protocols

#endif

